/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.NoOpMessageMonitorCallback;

public class EventProcessorLatencyMonitor
implements MessageMonitor<EventMessage<?>>,
MetricSet {
    private final AtomicLong lastReceivedTime = new AtomicLong(-1L);
    private final AtomicLong lastProcessedTime = new AtomicLong(-1L);

    public MessageMonitor.MonitorCallback onMessageIngested(final EventMessage<?> message) {
        if (message == null) {
            return NoOpMessageMonitorCallback.INSTANCE;
        }
        this.updateIfMaxValue(this.lastReceivedTime, message.getTimestamp().toEpochMilli());
        return new MessageMonitor.MonitorCallback(){

            public void reportSuccess() {
                this.update();
            }

            public void reportFailure(Throwable cause) {
                this.update();
            }

            public void reportIgnored() {
                this.update();
            }

            private void update() {
                EventProcessorLatencyMonitor.this.updateIfMaxValue(EventProcessorLatencyMonitor.this.lastProcessedTime, message.getTimestamp().toEpochMilli());
            }
        };
    }

    public Map<String, Metric> getMetrics() {
        long lastProcessedTime = this.lastProcessedTime.longValue();
        long lastReceivedTime = this.lastReceivedTime.longValue();
        long processTime = lastReceivedTime == -1L || lastProcessedTime == -1L ? 0L : lastReceivedTime - lastProcessedTime;
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("latency", (Metric)((Gauge)() -> processTime));
        return metrics;
    }

    private void updateIfMaxValue(AtomicLong atomicLong, long timestamp) {
        atomicLong.accumulateAndGet(timestamp, (currentValue, newValue) -> newValue > currentValue ? newValue : currentValue);
    }
}

