/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.config.Configurer;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.messaging.Message;
import org.axonframework.metrics.CapacityMonitor;
import org.axonframework.metrics.EventProcessorLatencyMonitor;
import org.axonframework.metrics.MessageCountingMonitor;
import org.axonframework.metrics.MessageTimerMonitor;
import org.axonframework.monitoring.MessageMonitor;
import org.axonframework.monitoring.MultiMessageMonitor;

public class GlobalMetricRegistry {
    private final MetricRegistry registry;

    public GlobalMetricRegistry() {
        this(new MetricRegistry());
    }

    public GlobalMetricRegistry(MetricRegistry metricRegistry) {
        this.registry = metricRegistry;
    }

    public Configurer registerWithConfigurer(Configurer configurer) {
        return configurer.configureMessageMonitor(configuration -> (componentType, componentName) -> this.registerComponent((Class<?>)componentType, (String)componentName));
    }

    public <T extends Metric> void registerMetric(String name, T metric) {
        this.registry.register(name, metric);
    }

    public MessageMonitor<? extends Message<?>> registerComponent(Class<?> componentType, String componentName) {
        if (EventProcessor.class.isAssignableFrom(componentType)) {
            return this.registerEventProcessor(componentName);
        }
        if (CommandBus.class.isAssignableFrom(componentType)) {
            return this.registerCommandBus(componentName);
        }
        if (EventBus.class.isAssignableFrom(componentType)) {
            return this.registerEventBus(componentName);
        }
        throw new IllegalArgumentException(String.format("Unrecognized component: [%s]", componentType));
    }

    public MessageMonitor<? super EventMessage<?>> registerEventProcessor(String eventProcessorName) {
        MessageTimerMonitor messageTimerMonitor = new MessageTimerMonitor();
        EventProcessorLatencyMonitor eventProcessorLatencyMonitor = new EventProcessorLatencyMonitor();
        CapacityMonitor capacityMonitor = new CapacityMonitor(1L, TimeUnit.MINUTES);
        MessageCountingMonitor messageCountingMonitor = new MessageCountingMonitor();
        MetricRegistry eventProcessingRegistry = new MetricRegistry();
        eventProcessingRegistry.register("messageTimer", (Metric)messageTimerMonitor);
        eventProcessingRegistry.register("latency", (Metric)eventProcessorLatencyMonitor);
        eventProcessingRegistry.register("messageCounter", (Metric)messageCountingMonitor);
        this.registry.register(eventProcessorName, (Metric)eventProcessingRegistry);
        ArrayList<Object> monitors = new ArrayList<Object>();
        monitors.add(messageTimerMonitor);
        monitors.add(eventProcessorLatencyMonitor);
        monitors.add(capacityMonitor);
        monitors.add(messageCountingMonitor);
        return new MultiMessageMonitor(monitors);
    }

    public MessageMonitor<EventMessage<?>> registerEventBus(String name) {
        MessageTimerMonitor messageTimerMonitor = new MessageTimerMonitor();
        MetricRegistry eventProcessingRegistry = new MetricRegistry();
        eventProcessingRegistry.register("messageTimer", (Metric)messageTimerMonitor);
        this.registry.register(name, (Metric)eventProcessingRegistry);
        ArrayList<MessageTimerMonitor> monitors = new ArrayList<MessageTimerMonitor>();
        monitors.add(messageTimerMonitor);
        return new MultiMessageMonitor(monitors);
    }

    public MessageMonitor<CommandMessage<?>> registerCommandBus(String name) {
        MessageTimerMonitor messageTimerMonitor = new MessageTimerMonitor();
        CapacityMonitor capacityMonitor = new CapacityMonitor(1L, TimeUnit.MINUTES);
        MessageCountingMonitor messageCountingMonitor = new MessageCountingMonitor();
        MetricRegistry commandHandlingRegistry = new MetricRegistry();
        commandHandlingRegistry.register("messageTimer", (Metric)messageTimerMonitor);
        commandHandlingRegistry.register("capacity", (Metric)capacityMonitor);
        commandHandlingRegistry.register("messageCounter", (Metric)messageCountingMonitor);
        this.registry.register(name, (Metric)commandHandlingRegistry);
        return new MultiMessageMonitor(new MessageMonitor[]{messageTimerMonitor, capacityMonitor, messageCountingMonitor});
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }
}

