/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.tracing;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.axonframework.common.BuilderUtils;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.core.annotation.MessageHandlingMember;
import org.axonframework.messaging.core.annotation.WrappedMessageHandlingMember;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.tracing.SpanFactory;

public class TracingHandlerEnhancerDefinition
implements HandlerEnhancerDefinition {
    private final SpanFactory spanFactory;
    private final boolean showEventSourcingHandlers;

    protected TracingHandlerEnhancerDefinition(Builder builder) {
        BuilderUtils.assertNonNull((Object)builder.spanFactory, (String)"SpanFactory must be provided!");
        this.spanFactory = builder.spanFactory;
        this.showEventSourcingHandlers = builder.showEventSourcingHandlers;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        if (!this.showEventSourcingHandlers && this.isEventSourcingHandler(original)) {
            return original;
        }
        Optional<Executable> unwrap = original.unwrap(Executable.class);
        if (!unwrap.isPresent()) {
            return original;
        }
        final String signature = this.toMethodSignature(unwrap.get());
        return new WrappedMessageHandlingMember<T>(original){

            @Override
            public Object handleSync(@Nonnull Message message, @Nonnull ProcessingContext context, T target) throws Exception {
                return TracingHandlerEnhancerDefinition.this.spanFactory.createInternalSpan(() -> TracingHandlerEnhancerDefinition.getSpanName(target, signature)).runCallable(() -> super.handleSync(message, context, target));
            }
        };
    }

    private static <T> String getSpanName(T target, String signature) {
        return target == null ? signature : target.getClass().getSimpleName() + "." + signature;
    }

    private boolean isEventSourcingHandler(MessageHandlingMember<?> original) {
        return original.attribute("EventSourcingHandler.payloadType").isPresent();
    }

    private String toMethodSignature(Executable executable) {
        return String.format("%s(%s)", executable.getName(), Arrays.stream(executable.getParameterTypes()).map(Class::getSimpleName).collect(Collectors.joining(",")));
    }

    public static class Builder {
        private SpanFactory spanFactory;
        private boolean showEventSourcingHandlers = false;

        public Builder spanFactory(SpanFactory spanFactory) {
            BuilderUtils.assertNonNull((Object)spanFactory, (String)"SpanFactory can not be set to null!");
            this.spanFactory = spanFactory;
            return this;
        }

        public Builder showEventSourcingHandlers(boolean showEventSourcingHandlers) {
            this.showEventSourcingHandlers = showEventSourcingHandlers;
            return this;
        }

        public TracingHandlerEnhancerDefinition build() {
            return new TracingHandlerEnhancerDefinition(this);
        }
    }
}

