/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.queryhandling.distributed;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.Registration;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.conversion.MessageConverter;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.queryhandling.QueryMessage;
import org.axonframework.messaging.queryhandling.QueryResponseMessage;
import org.axonframework.messaging.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.messaging.queryhandling.distributed.DelegatingQueryBusConnector;
import org.axonframework.messaging.queryhandling.distributed.QueryBusConnector;

public class PayloadConvertingQueryBusConnector
extends DelegatingQueryBusConnector {
    private final MessageConverter converter;
    private final Class<?> targetType;

    public PayloadConvertingQueryBusConnector(@Nonnull QueryBusConnector delegate, @Nonnull MessageConverter converter, @Nonnull Class<?> targetType) {
        super(delegate);
        this.converter = Objects.requireNonNull(converter, "The converter must not be null.");
        this.targetType = Objects.requireNonNull(targetType, "The targetType must not be null.");
    }

    @Override
    @Nonnull
    public MessageStream<QueryResponseMessage> query(@Nonnull QueryMessage query, @Nullable ProcessingContext context) {
        return this.delegate.query((QueryMessage)query.withConvertedPayload((Class)this.targetType, (Converter)this.converter), context);
    }

    @Override
    @Nonnull
    public MessageStream<QueryResponseMessage> subscriptionQuery(@Nonnull QueryMessage query, @Nullable ProcessingContext context, int updateBufferSize) {
        return this.delegate.subscriptionQuery((QueryMessage)query.withConvertedPayload((Class)this.targetType, (Converter)this.converter), context, updateBufferSize);
    }

    @Override
    public void onIncomingQuery(final @Nonnull QueryBusConnector.Handler handler) {
        this.delegate.onIncomingQuery(new QueryBusConnector.Handler(){

            @Override
            public MessageStream<QueryResponseMessage> query(@Nonnull QueryMessage query) {
                return handler.query(query).mapMessage(rm -> rm.withConvertedPayload((Class)PayloadConvertingQueryBusConnector.this.targetType, (Converter)PayloadConvertingQueryBusConnector.this.converter));
            }

            @Override
            @Nonnull
            public Registration registerUpdateHandler(@Nonnull QueryMessage subscriptionQueryMessage, final @Nonnull QueryBusConnector.UpdateCallback updateCallback) {
                return handler.registerUpdateHandler(subscriptionQueryMessage, new QueryBusConnector.UpdateCallback(){

                    @Override
                    @Nonnull
                    public CompletableFuture<Void> sendUpdate(@Nonnull SubscriptionQueryUpdateMessage update) {
                        return updateCallback.sendUpdate((SubscriptionQueryUpdateMessage)update.withConvertedPayload((Class)PayloadConvertingQueryBusConnector.this.targetType, (Converter)PayloadConvertingQueryBusConnector.this.converter));
                    }

                    @Override
                    public CompletableFuture<Void> complete() {
                        return updateCallback.complete();
                    }

                    @Override
                    public CompletableFuture<Void> completeExceptionally(@Nonnull Throwable cause) {
                        return updateCallback.completeExceptionally(cause);
                    }
                });
            }
        });
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf((Object)this.delegate);
        descriptor.describeProperty("converter", (Object)this.converter);
        descriptor.describeProperty("targetType", this.targetType);
    }
}

