/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.queryhandling.distributed;

import jakarta.annotation.Nonnull;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.configuration.ComponentDecorator;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.ConfigurationEnhancer;
import org.axonframework.common.configuration.DecoratorDefinition;
import org.axonframework.common.configuration.SearchScope;
import org.axonframework.messaging.queryhandling.QueryBus;
import org.axonframework.messaging.queryhandling.distributed.DistributedQueryBus;
import org.axonframework.messaging.queryhandling.distributed.DistributedQueryBusConfiguration;
import org.axonframework.messaging.queryhandling.distributed.QueryBusConnector;

@Internal
public class DistributedQueryBusConfigurationEnhancer
implements ConfigurationEnhancer {
    public static final int DISTRIBUTED_QUERY_BUS_ORDER = -2147483598;

    public void enhance(@Nonnull ComponentRegistry componentRegistry) {
        if (componentRegistry.hasComponent(QueryBusConnector.class)) {
            componentRegistry.registerIfNotPresent(DistributedQueryBusConfiguration.class, c -> DistributedQueryBusConfiguration.DEFAULT, SearchScope.ALL).registerDecorator(DecoratorDefinition.forType(QueryBus.class).with(this.queryBusDecoratorDefinition()).order(-2147483598));
        }
    }

    private ComponentDecorator<QueryBus, QueryBus> queryBusDecoratorDefinition() {
        return (config, name, delegate) -> {
            if (delegate instanceof DistributedQueryBus) {
                return delegate;
            }
            DistributedQueryBusConfiguration queryBusConfiguration = (DistributedQueryBusConfiguration)config.getComponent(DistributedQueryBusConfiguration.class);
            return config.getOptionalComponent(QueryBusConnector.class).map(connector -> DistributedQueryBusConfigurationEnhancer.distributedQueryBus(delegate, connector, queryBusConfiguration)).orElse((QueryBus)delegate);
        };
    }

    @Nonnull
    private static QueryBus distributedQueryBus(QueryBus delegate, QueryBusConnector connector, DistributedQueryBusConfiguration queryBusConfiguration) {
        return new DistributedQueryBus(delegate, connector, queryBusConfiguration);
    }
}

