/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.monitoring.configuration;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import org.axonframework.common.TypeReference;
import org.axonframework.common.configuration.Component;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.ComponentDefinition;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.LazyInitializedComponentDefinition;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.monitoring.MessageMonitor;
import org.axonframework.messaging.monitoring.MultiMessageMonitor;
import org.axonframework.messaging.monitoring.NoOpMessageMonitor;
import org.axonframework.messaging.monitoring.configuration.MessageMonitorRegistry;
import org.axonframework.messaging.queryhandling.QueryMessage;
import org.axonframework.messaging.queryhandling.SubscriptionQueryUpdateMessage;

public class DefaultMessageMonitorRegistry
implements MessageMonitorRegistry {
    private static final TypeReference<MessageMonitor<Message>> MONITOR_TYPE_REF = new TypeReference<MessageMonitor<Message>>(){};
    private static final TypeReference<MessageMonitor<? super CommandMessage>> COMMAND_MONITOR_TYPE_REF = new TypeReference<MessageMonitor<? super CommandMessage>>(){};
    private static final TypeReference<MessageMonitor<? super EventMessage>> EVENT_MONITOR_TYPE_REF = new TypeReference<MessageMonitor<? super EventMessage>>(){};
    private static final TypeReference<MessageMonitor<? super QueryMessage>> QUERY_MONITOR_TYPE_REF = new TypeReference<MessageMonitor<? super QueryMessage>>(){};
    private static final TypeReference<MessageMonitor<? super SubscriptionQueryUpdateMessage>> SUBSCRIPTION_QUERY_UPDATE_MONITOR_TYPE_REF = new TypeReference<MessageMonitor<? super SubscriptionQueryUpdateMessage>>(){};
    private final List<ComponentDefinition<MessageMonitor<? super CommandMessage>>> commandMonitorDefinitions = new ArrayList<ComponentDefinition<MessageMonitor<? super CommandMessage>>>();
    private final List<ComponentDefinition<MessageMonitor<? super EventMessage>>> eventMonitorDefinitions = new ArrayList<ComponentDefinition<MessageMonitor<? super EventMessage>>>();
    private final List<ComponentDefinition<MessageMonitor<? super QueryMessage>>> queryMonitorDefinitions = new ArrayList<ComponentDefinition<MessageMonitor<? super QueryMessage>>>();
    private final List<ComponentDefinition<MessageMonitor<? super SubscriptionQueryUpdateMessage>>> subscriptionQueryUpdateMonitorDefinitions = new ArrayList<ComponentDefinition<MessageMonitor<? super SubscriptionQueryUpdateMessage>>>();

    @Override
    @Nonnull
    public MessageMonitorRegistry registerMonitor(@Nonnull ComponentBuilder<MessageMonitor<Message>> monitorBuilder) {
        GenericMonitorDefinition genericMonitorDef = new GenericMonitorDefinition(monitorBuilder);
        this.registerCommandMonitor((ComponentBuilder<MessageMonitor<? super CommandMessage>>)((ComponentBuilder)arg_0 -> ((GenericMonitorDefinition)genericMonitorDef).doResolve(arg_0)));
        this.registerEventMonitor((ComponentBuilder<MessageMonitor<? super EventMessage>>)((ComponentBuilder)arg_0 -> ((GenericMonitorDefinition)genericMonitorDef).doResolve(arg_0)));
        this.registerQueryMonitor((ComponentBuilder<MessageMonitor<? super QueryMessage>>)((ComponentBuilder)arg_0 -> ((GenericMonitorDefinition)genericMonitorDef).doResolve(arg_0)));
        this.registerSubscriptionQueryUpdateMonitor((ComponentBuilder<MessageMonitor<? super SubscriptionQueryUpdateMessage>>)((ComponentBuilder)arg_0 -> ((GenericMonitorDefinition)genericMonitorDef).doResolve(arg_0)));
        return this;
    }

    @Override
    @Nonnull
    public MessageMonitorRegistry registerEventMonitor(@Nonnull ComponentBuilder<MessageMonitor<? super EventMessage>> monitorBuilder) {
        this.eventMonitorDefinitions.add((ComponentDefinition<MessageMonitor<? super EventMessage>>)ComponentDefinition.ofType(EVENT_MONITOR_TYPE_REF).withBuilder(monitorBuilder));
        return this;
    }

    @Override
    @Nonnull
    public MessageMonitorRegistry registerCommandMonitor(@Nonnull ComponentBuilder<MessageMonitor<? super CommandMessage>> monitorBuilder) {
        this.commandMonitorDefinitions.add((ComponentDefinition<MessageMonitor<? super CommandMessage>>)ComponentDefinition.ofType(COMMAND_MONITOR_TYPE_REF).withBuilder(monitorBuilder));
        return this;
    }

    @Override
    @Nonnull
    public MessageMonitorRegistry registerQueryMonitor(@Nonnull ComponentBuilder<MessageMonitor<? super QueryMessage>> monitorBuilder) {
        this.queryMonitorDefinitions.add((ComponentDefinition<MessageMonitor<? super QueryMessage>>)ComponentDefinition.ofType(QUERY_MONITOR_TYPE_REF).withBuilder(monitorBuilder));
        return this;
    }

    @Override
    @Nonnull
    public MessageMonitorRegistry registerSubscriptionQueryUpdateMonitor(@Nonnull ComponentBuilder<MessageMonitor<? super SubscriptionQueryUpdateMessage>> monitorBuilder) {
        this.subscriptionQueryUpdateMonitorDefinitions.add((ComponentDefinition<MessageMonitor<? super SubscriptionQueryUpdateMessage>>)ComponentDefinition.ofType(SUBSCRIPTION_QUERY_UPDATE_MONITOR_TYPE_REF).withBuilder(monitorBuilder));
        return this;
    }

    @Override
    public MessageMonitor<? super CommandMessage> commandMonitor(@Nonnull Configuration config) {
        return DefaultMessageMonitorRegistry.resolveMonitor(this.commandMonitorDefinitions, config);
    }

    @Override
    public MessageMonitor<? super EventMessage> eventMonitor(@Nonnull Configuration config) {
        return DefaultMessageMonitorRegistry.resolveMonitor(this.eventMonitorDefinitions, config);
    }

    @Override
    public MessageMonitor<? super QueryMessage> queryMonitor(@Nonnull Configuration config) {
        return DefaultMessageMonitorRegistry.resolveMonitor(this.queryMonitorDefinitions, config);
    }

    @Override
    public MessageMonitor<? super SubscriptionQueryUpdateMessage> subscriptionQueryUpdateMonitor(@Nonnull Configuration config) {
        return DefaultMessageMonitorRegistry.resolveMonitor(this.subscriptionQueryUpdateMonitorDefinitions, config);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("commandMonitors", this.commandMonitorDefinitions);
        descriptor.describeProperty("eventMonitors", this.eventMonitorDefinitions);
        descriptor.describeProperty("queryMonitors", this.queryMonitorDefinitions);
        descriptor.describeProperty("subscriptionQueryUpdateMonitors", this.subscriptionQueryUpdateMonitorDefinitions);
    }

    private static <T extends Message> MessageMonitor<? super T> resolveMonitor(@Nonnull List<ComponentDefinition<MessageMonitor<? super T>>> definitions, @Nonnull Configuration config) {
        ArrayList monitors = new ArrayList();
        for (ComponentDefinition<MessageMonitor<T>> componentDefinition : definitions) {
            if (!(componentDefinition instanceof ComponentDefinition.ComponentCreator)) {
                throw new IllegalArgumentException("Unsupported component definition type: " + String.valueOf(componentDefinition));
            }
            ComponentDefinition.ComponentCreator creator = (ComponentDefinition.ComponentCreator)componentDefinition;
            monitors.add((MessageMonitor)creator.createComponent().resolve(config));
        }
        return !monitors.isEmpty() ? new MultiMessageMonitor(monitors) : NoOpMessageMonitor.INSTANCE;
    }

    private static class GenericMonitorDefinition
    extends LazyInitializedComponentDefinition<MessageMonitor<Message>, MessageMonitor<Message>> {
        GenericMonitorDefinition(@Nonnull ComponentBuilder<MessageMonitor<Message>> builder) {
            super(new Component.Identifier(MONITOR_TYPE_REF, null), builder);
        }
    }
}

