/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventstreaming;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.eventstreaming.AnyEvent;
import org.axonframework.messaging.eventstreaming.EventCriterion;
import org.axonframework.messaging.eventstreaming.EventTypeRestrictableEventCriteria;
import org.axonframework.messaging.eventstreaming.OrEventCriteria;
import org.axonframework.messaging.eventstreaming.OrEventCriteriaBuilder;
import org.axonframework.messaging.eventstreaming.Tag;
import org.axonframework.messaging.eventstreaming.TagAndTypeFilteredEventCriteria;
import org.axonframework.messaging.eventstreaming.TagFilteredEventCriteria;

public sealed interface EventCriteria
permits OrEventCriteria, TagAndTypeFilteredEventCriteria, TagFilteredEventCriteria, AnyEvent, EventCriterion, EventTypeRestrictableEventCriteria {
    public static EventTypeRestrictableEventCriteria havingAnyTag() {
        return AnyEvent.INSTANCE;
    }

    public static EventTypeRestrictableEventCriteria havingTags(@Nonnull Set<Tag> tags) {
        if (tags.isEmpty()) {
            return AnyEvent.INSTANCE;
        }
        return new TagFilteredEventCriteria(tags);
    }

    public static EventTypeRestrictableEventCriteria havingTags(Tag ... tags) {
        return EventCriteria.havingTags(Set.of(tags));
    }

    public static EventTypeRestrictableEventCriteria havingTags(String ... tags) {
        if ((tags.length & 1) == 1) {
            throw new IllegalArgumentException("Tags must be in pairs of key and value");
        }
        HashSet<Tag> tagSet = new HashSet<Tag>();
        for (int i = 0; i < tags.length; i += 2) {
            tagSet.add(new Tag(tags[i], tags[i + 1]));
        }
        return EventCriteria.havingTags(tagSet);
    }

    public EventCriteria or(EventCriteria var1);

    public static EventCriteria either(@Nonnull Collection<EventCriteria> eventCriteria) {
        Objects.requireNonNull(eventCriteria, "The eventCriteria cannot be null.");
        return new OrEventCriteria(new HashSet<EventCriteria>(eventCriteria));
    }

    public static EventCriteria either(EventCriteria ... eventCriteria) {
        return new OrEventCriteria(Arrays.stream(eventCriteria).collect(Collectors.toSet()));
    }

    default public OrEventCriteriaBuilder or() {
        return new OrEventCriteriaBuilder(this);
    }

    public boolean matches(@Nonnull QualifiedName var1, @Nonnull Set<Tag> var2);

    public Set<EventCriterion> flatten();

    public boolean hasCriteria();
}

