/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.sequencing;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.sequencing.SequencingPolicy;

public class HierarchicalSequencingPolicy
implements SequencingPolicy {
    private final SequencingPolicy primary;
    private final SequencingPolicy secondary;

    public HierarchicalSequencingPolicy(@Nonnull SequencingPolicy primary, @Nonnull SequencingPolicy secondary) {
        this.primary = Objects.requireNonNull(primary, "Primary may not be null.");
        this.secondary = Objects.requireNonNull(secondary, "Secondary may not be null.");
    }

    @Override
    public Optional<Object> getSequenceIdentifierFor(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        return this.primary.getSequenceIdentifierFor(event, context).or(() -> this.secondary.getSequenceIdentifierFor(event, context));
    }
}

