/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.replay.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.processing.streaming.token.ReplayToken;
import org.axonframework.messaging.eventhandling.processing.streaming.token.TrackingToken;
import org.axonframework.messaging.eventhandling.replay.ReplayStatus;

public class ReplayParameterResolverFactory
implements ParameterResolverFactory {
    @Nullable
    public ParameterResolver<ReplayStatus> createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        if (ReplayStatus.class.isAssignableFrom(parameters[parameterIndex].getType())) {
            return new ReplayParameterResolver();
        }
        return null;
    }

    private static class ReplayParameterResolver
    implements ParameterResolver<ReplayStatus> {
        private ReplayParameterResolver() {
        }

        @Override
        @Nonnull
        public CompletableFuture<ReplayStatus> resolveParameterValue(@Nonnull ProcessingContext context) {
            Optional<TrackingToken> optionalToken = TrackingToken.fromContext(context);
            if (Message.fromContext(context) instanceof EventMessage && optionalToken.isPresent()) {
                return CompletableFuture.completedFuture(ReplayToken.isReplay(optionalToken.get()) ? ReplayStatus.REPLAY : ReplayStatus.REGULAR);
            }
            return CompletableFuture.completedFuture(ReplayStatus.REGULAR);
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return Message.fromContext(context) instanceof EventMessage;
        }
    }
}

