/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.subscribing;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.axonframework.common.configuration.BaseModule;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.ComponentDefinition;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.ModuleBuilder;
import org.axonframework.messaging.eventhandling.EventHandlingComponent;
import org.axonframework.messaging.eventhandling.configuration.DefaultEventHandlingComponentsConfigurer;
import org.axonframework.messaging.eventhandling.configuration.EventHandlingComponentsConfigurer;
import org.axonframework.messaging.eventhandling.configuration.EventProcessorConfiguration;
import org.axonframework.messaging.eventhandling.configuration.EventProcessorCustomization;
import org.axonframework.messaging.eventhandling.configuration.EventProcessorModule;
import org.axonframework.messaging.eventhandling.interception.InterceptingEventHandlingComponent;
import org.axonframework.messaging.eventhandling.processing.streaming.segmenting.SequenceCachingEventHandlingComponent;
import org.axonframework.messaging.eventhandling.processing.subscribing.SubscribingEventProcessor;
import org.axonframework.messaging.eventhandling.processing.subscribing.SubscribingEventProcessorConfiguration;

public class SubscribingEventProcessorModule
extends BaseModule<SubscribingEventProcessorModule>
implements EventProcessorModule,
ModuleBuilder<SubscribingEventProcessorModule>,
EventProcessorModule.EventHandlingPhase<SubscribingEventProcessorModule, SubscribingEventProcessorConfiguration>,
EventProcessorModule.CustomizationPhase<SubscribingEventProcessorModule, SubscribingEventProcessorConfiguration> {
    private final String processorName;
    private List<ComponentBuilder<EventHandlingComponent>> eventHandlingComponentBuilders;
    private ComponentBuilder<SubscribingEventProcessorConfiguration> customizedProcessorConfigurationBuilder;

    public SubscribingEventProcessorModule(@Nonnull String processorName) {
        super(processorName);
        this.processorName = processorName;
    }

    public SubscribingEventProcessorModule build() {
        this.registerCustomizedConfiguration();
        this.registerEventHandlingComponents();
        this.registerEventProcessor();
        return this;
    }

    private void registerCustomizedConfiguration() {
        this.componentRegistry(cr -> cr.registerComponent(ComponentDefinition.ofType(SubscribingEventProcessorConfiguration.class).withBuilder(cfg -> (SubscribingEventProcessorConfiguration)this.customizedProcessorConfigurationBuilder.build(cfg))));
    }

    private void registerEventProcessor() {
        ComponentDefinition processorComponentDefinition = ComponentDefinition.ofTypeAndName(SubscribingEventProcessor.class, (String)this.processorName).withBuilder(cfg -> new SubscribingEventProcessor(this.processorName, this.getEventHandlingComponents(cfg), (SubscribingEventProcessorConfiguration)cfg.getComponent(SubscribingEventProcessorConfiguration.class))).onStart(0, (cfg, processor) -> processor.start()).onShutdown(0, (cfg, processor) -> processor.shutdown());
        this.componentRegistry(cr -> cr.registerComponent(processorComponentDefinition));
    }

    private void registerEventHandlingComponents() {
        for (int i = 0; i < this.eventHandlingComponentBuilders.size(); ++i) {
            ComponentBuilder<EventHandlingComponent> componentBuilder = this.eventHandlingComponentBuilders.get(i);
            String componentName = this.processorEventHandlingComponentName(i);
            this.componentRegistry(cr -> {
                cr.registerComponent(EventHandlingComponent.class, componentName, cfg -> {
                    EventHandlingComponent component = (EventHandlingComponent)componentBuilder.build(cfg);
                    return new SequenceCachingEventHandlingComponent(component);
                });
                cr.registerDecorator(EventHandlingComponent.class, componentName, -2147483548, (config, name, delegate) -> {
                    SubscribingEventProcessorConfiguration configuration = (SubscribingEventProcessorConfiguration)config.getComponent(SubscribingEventProcessorConfiguration.class);
                    return new InterceptingEventHandlingComponent(configuration.interceptors(), (EventHandlingComponent)delegate);
                });
            });
        }
    }

    private List<EventHandlingComponent> getEventHandlingComponents(Configuration configuration) {
        return IntStream.range(0, this.eventHandlingComponentBuilders.size()).mapToObj(i -> {
            String componentName = this.processorEventHandlingComponentName(i);
            return (EventHandlingComponent)configuration.getComponent(EventHandlingComponent.class, componentName);
        }).toList();
    }

    @Nonnull
    private String processorEventHandlingComponentName(int index) {
        return "EventHandlingComponent[" + this.processorName + "][" + index + "]";
    }

    @Override
    public SubscribingEventProcessorModule customized(@Nonnull BiFunction<Configuration, SubscribingEventProcessorConfiguration, SubscribingEventProcessorConfiguration> instanceCustomization) {
        this.customizedProcessorConfigurationBuilder = cfg -> {
            SubscribingEventProcessorConfiguration typeCustomization = (SubscribingEventProcessorConfiguration)SubscribingEventProcessorModule.typeSpecificCustomizationOrNoOp(cfg).apply(cfg, SubscribingEventProcessorModule.defaultEventProcessorsConfiguration(cfg));
            return (SubscribingEventProcessorConfiguration)instanceCustomization.apply(cfg, typeCustomization);
        };
        return this;
    }

    @Override
    public SubscribingEventProcessorModule notCustomized() {
        if (this.customizedProcessorConfigurationBuilder == null) {
            this.customized((cfg, config) -> config);
        }
        return this;
    }

    @Nonnull
    private static SubscribingEventProcessorConfiguration defaultEventProcessorsConfiguration(Configuration cfg) {
        return new SubscribingEventProcessorConfiguration((EventProcessorConfiguration)SubscribingEventProcessorModule.parentSharedCustomizationOrDefault(cfg).apply(cfg, new EventProcessorConfiguration(cfg)), cfg);
    }

    private static Customization typeSpecificCustomizationOrNoOp(Configuration cfg) {
        return cfg.getOptionalComponent(Customization.class).orElseGet(Customization::noOp);
    }

    private static EventProcessorCustomization parentSharedCustomizationOrDefault(Configuration cfg) {
        return cfg.getOptionalComponent(EventProcessorCustomization.class).orElseGet(EventProcessorCustomization::noOp);
    }

    @Override
    public EventProcessorModule.CustomizationPhase<SubscribingEventProcessorModule, SubscribingEventProcessorConfiguration> eventHandlingComponents(@Nonnull Function<EventHandlingComponentsConfigurer.RequiredComponentPhase, EventHandlingComponentsConfigurer.CompletePhase> configurerTask) {
        Objects.requireNonNull(configurerTask, "configurerTask may not be null");
        DefaultEventHandlingComponentsConfigurer componentsConfigurer = new DefaultEventHandlingComponentsConfigurer();
        this.eventHandlingComponentBuilders = configurerTask.apply(componentsConfigurer).toList();
        return this;
    }

    @FunctionalInterface
    public static interface Customization
    extends BiFunction<Configuration, SubscribingEventProcessorConfiguration, SubscribingEventProcessorConfiguration> {
        public static Customization noOp() {
            return (config, pConfig) -> pConfig;
        }

        default public Customization andThen(@Nonnull Customization other) {
            Objects.requireNonNull(other, "other may not be null");
            return (config, pConfig) -> (SubscribingEventProcessorConfiguration)other.apply(config, (SubscribingEventProcessorConfiguration)this.apply(config, pConfig));
        }
    }
}

