/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.streaming.token;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.OptionalLong;
import org.axonframework.common.Assert;
import org.axonframework.messaging.eventhandling.processing.streaming.token.TrackingToken;

public class GlobalSequenceTrackingToken
implements TrackingToken,
Comparable<GlobalSequenceTrackingToken> {
    private final long globalIndex;

    @JsonCreator
    @ConstructorProperties(value={"globalIndex"})
    public GlobalSequenceTrackingToken(@JsonProperty(value="globalIndex") long globalIndex) {
        this.globalIndex = globalIndex;
    }

    public long getGlobalIndex() {
        return this.globalIndex;
    }

    public GlobalSequenceTrackingToken offsetBy(int offset) {
        return new GlobalSequenceTrackingToken(this.globalIndex + (long)offset);
    }

    public GlobalSequenceTrackingToken next() {
        return this.offsetBy(1);
    }

    @Override
    public TrackingToken lowerBound(TrackingToken other) {
        Assert.isTrue((boolean)(other instanceof GlobalSequenceTrackingToken), () -> "Incompatible token type provided:" + other.getClass().getSimpleName());
        GlobalSequenceTrackingToken otherToken = (GlobalSequenceTrackingToken)other;
        if (otherToken.globalIndex < this.globalIndex) {
            return otherToken;
        }
        return this;
    }

    @Override
    public TrackingToken upperBound(TrackingToken other) {
        Assert.isTrue((boolean)(other instanceof GlobalSequenceTrackingToken), () -> "Incompatible token type provided:" + other.getClass().getSimpleName());
        if (((GlobalSequenceTrackingToken)other).globalIndex > this.globalIndex) {
            return other;
        }
        return this;
    }

    @Override
    public boolean covers(TrackingToken other) {
        Assert.isTrue((other == null || other instanceof GlobalSequenceTrackingToken ? 1 : 0) != 0, () -> "Incompatible token type provided:" + (other != null ? other.getClass().getSimpleName() : "null"));
        GlobalSequenceTrackingToken otherToken = (GlobalSequenceTrackingToken)other;
        return otherToken == null || otherToken.globalIndex <= this.globalIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalSequenceTrackingToken that = (GlobalSequenceTrackingToken)o;
        return this.globalIndex == that.globalIndex;
    }

    public int hashCode() {
        return Objects.hash(this.globalIndex);
    }

    public String toString() {
        return "IndexTrackingToken{globalIndex=" + this.globalIndex + "}";
    }

    @Override
    public int compareTo(GlobalSequenceTrackingToken o) {
        return Long.compare(this.globalIndex, o.globalIndex);
    }

    @Override
    public OptionalLong position() {
        return OptionalLong.of(this.globalIndex);
    }
}

