/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.streaming.segmenting;

import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.axonframework.common.annotation.Internal;
import org.axonframework.messaging.core.Context;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.DelegatingEventHandlingComponent;
import org.axonframework.messaging.eventhandling.EventHandlingComponent;
import org.axonframework.messaging.eventhandling.EventMessage;

@Internal
public class SequenceCachingEventHandlingComponent
extends DelegatingEventHandlingComponent {
    private final Context.ResourceKey<SequenceIdentifiersCache> resourceKey = Context.ResourceKey.withLabel("sequenceIdentifiersCache");

    @Internal
    public SequenceCachingEventHandlingComponent(@Nonnull EventHandlingComponent delegate) {
        super(delegate);
    }

    @Override
    @Nonnull
    public Object sequenceIdentifierFor(@Nonnull EventMessage event, @Nonnull ProcessingContext context) {
        String eventIdentifier = event.identifier();
        SequenceIdentifiersCache cache = context.computeResourceIfAbsent(this.resourceKey, SequenceIdentifiersCache::new);
        Optional<Object> cachedSequenceId = cache.get(eventIdentifier);
        if (cachedSequenceId.isPresent()) {
            return cachedSequenceId.get();
        }
        Object sequenceIdentifier = super.sequenceIdentifierFor(event, context);
        cache.put(eventIdentifier, sequenceIdentifier);
        return sequenceIdentifier;
    }

    private static final class SequenceIdentifiersCache {
        private final Map<String, Object> cache = new HashMap<String, Object>();

        SequenceIdentifiersCache() {
        }

        void put(@Nonnull String eventIdentifier, @Nonnull Object sequenceIdentifier) {
            this.cache.put(eventIdentifier, sequenceIdentifier);
        }

        @Nonnull
        Optional<Object> get(@Nonnull String eventIdentifier) {
            return Optional.ofNullable(this.cache.get(eventIdentifier));
        }
    }
}

