/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.streaming.segmenting;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import org.axonframework.common.Assert;
import org.axonframework.common.annotation.Internal;
import org.axonframework.messaging.core.Context;

public class Segment
implements Comparable<Segment> {
    public static final Context.ResourceKey<Segment> RESOURCE_KEY = Context.ResourceKey.withLabel("segment");
    private static final int ZERO_MASK = 0;
    public static final Segment ROOT_SEGMENT = new Segment(0, 0);
    private final int segmentId;
    private final int mask;

    public static Context addToContext(@Nonnull Context context, @Nonnull Segment segment) {
        return context.withResource(RESOURCE_KEY, segment);
    }

    public static Optional<Segment> fromContext(@Nonnull Context context) {
        return Optional.ofNullable(context.getResource(RESOURCE_KEY));
    }

    public static List<Segment> splitBalanced(Segment segment, int numberOfTimes) {
        TreeSet<Segment> toBeSplit = new TreeSet<Segment>(Comparator.comparing(Segment::getMask).thenComparing(Segment::getSegmentId));
        toBeSplit.add(segment);
        for (int i = 0; i < numberOfTimes; ++i) {
            Segment workingSegment = (Segment)toBeSplit.first();
            toBeSplit.remove(workingSegment);
            toBeSplit.addAll(Arrays.asList(workingSegment.split()));
        }
        ArrayList<Segment> result = new ArrayList<Segment>(toBeSplit);
        result.sort(Comparator.comparing(Segment::getSegmentId));
        return result;
    }

    @Internal
    public Segment(int segmentId, int mask) {
        Assert.isTrue((mask == 0 || mask + 1 == Integer.highestOneBit(mask + 1) ? 1 : 0) != 0, () -> "Invalid mask. It must end on a consecutive series of 1s");
        this.segmentId = segmentId;
        this.mask = mask;
    }

    public Segment mergedWith(Segment other) {
        Assert.isTrue((boolean)this.isMergeableWith(other), () -> "Given " + String.valueOf(other) + " cannot be merged with " + String.valueOf(this));
        return new Segment(Math.min(this.segmentId, other.segmentId), this.mask >>> 1);
    }

    public int mergeableSegmentId() {
        int parentMask = this.mask >>> 1;
        int firstBit = this.mask ^ parentMask;
        return this.segmentId ^ firstBit;
    }

    public boolean isMergeableWith(Segment other) {
        return this.mask == other.mask && this.mergeableSegmentId() == other.getSegmentId();
    }

    public int getSegmentId() {
        return this.segmentId;
    }

    public int getMask() {
        return this.mask;
    }

    public boolean matches(int value) {
        return this.mask == 0 || (this.mask & value) == this.segmentId;
    }

    public boolean matches(Object value) {
        return this.mask == 0 || this.matches(Objects.hashCode(value));
    }

    public Segment[] split() {
        if (this.mask << 1 < 0) {
            throw new IllegalStateException("Unable to split the given segmentId, as the mask exceeds the max mask size.");
        }
        Segment[] segments = new Segment[2];
        int newMask = (this.mask << 1) + 1;
        int newSegment = this.segmentId + (this.mask == 0 ? 1 : newMask ^ this.mask);
        segments[0] = new Segment(this.segmentId, newMask);
        segments[1] = new Segment(newSegment, newMask);
        return segments;
    }

    public int splitSegmentId() {
        return this.segmentId + (this.mask == 0 ? 1 : (this.mask << 1) + 1 ^ this.mask);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment that = (Segment)o;
        return this.segmentId == that.segmentId && this.mask == that.mask;
    }

    public String toString() {
        return String.format("Segment[%d/%s]", this.getSegmentId(), this.getMask());
    }

    public int hashCode() {
        return Objects.hash(this.segmentId, this.mask);
    }

    @Override
    public int compareTo(Segment that) {
        return Integer.compare(this.segmentId, that.segmentId);
    }
}

