/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.streaming.pooled;

import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.FutureUtils;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.core.unitofwork.UnitOfWorkFactory;
import org.axonframework.messaging.eventhandling.processing.streaming.pooled.CoordinatorTask;
import org.axonframework.messaging.eventhandling.processing.streaming.pooled.WorkPackage;
import org.axonframework.messaging.eventhandling.processing.streaming.segmenting.Segment;
import org.axonframework.messaging.eventhandling.processing.streaming.token.store.TokenStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClaimTask
extends CoordinatorTask {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String name;
    private final int segmentId;
    private final Map<Integer, WorkPackage> workPackages;
    private final Map<Integer, Instant> releasesDeadlines;
    private final TokenStore tokenStore;
    private final UnitOfWorkFactory unitOfWorkFactory;

    ClaimTask(CompletableFuture<Boolean> result, String name, int segmentId, Map<Integer, WorkPackage> workPackages, Map<Integer, Instant> releasesDeadlines, TokenStore tokenStore, UnitOfWorkFactory unitOfWorkFactory) {
        super(result, name);
        this.name = name;
        this.segmentId = segmentId;
        this.workPackages = workPackages;
        this.releasesDeadlines = releasesDeadlines;
        this.unitOfWorkFactory = unitOfWorkFactory;
        this.tokenStore = tokenStore;
    }

    @Override
    protected CompletableFuture<Boolean> task() {
        logger.debug("Processor [{}] will perform claim instruction for segment {}.", (Object)this.name, (Object)this.segmentId);
        if (this.workPackages.containsKey(this.segmentId)) {
            return CompletableFuture.completedFuture(true);
        }
        this.releasesDeadlines.remove(this.segmentId);
        List segments = (List)FutureUtils.joinAndUnwrap(this.unitOfWorkFactory.create().executeWithResult(context -> this.tokenStore.fetchAvailableSegments(this.name, (ProcessingContext)context)));
        if (segments == null) {
            logger.info("Processor [{}] cannot claim segment {}. It is not available.", (Object)this.name, (Object)this.segmentId);
            return CompletableFuture.completedFuture(false);
        }
        Optional<Segment> segmentToClaim = segments.stream().filter(segment -> segment.getSegmentId() == this.segmentId).findFirst();
        if (segmentToClaim.isEmpty()) {
            logger.info("Processor [{}] cannot claim segment {}. It is not available.", (Object)this.name, (Object)this.segmentId);
            return CompletableFuture.completedFuture(false);
        }
        try {
            FutureUtils.joinAndUnwrap(this.unitOfWorkFactory.create().executeWithResult(context -> this.tokenStore.fetchToken(this.name, this.segmentId, (ProcessingContext)context)));
        }
        catch (Exception e) {
            logger.warn("Processor [{}] cannot claim segment {} due to an error.", new Object[]{this.name, this.segmentId, e});
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.completedFuture(true);
    }

    @Override
    String getDescription() {
        return "Claim Task for segment " + this.segmentId;
    }
}

