/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.annotation;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;

public class PayloadParameterResolver
implements ParameterResolver<Object> {
    private final Class<?> payloadType;

    public PayloadParameterResolver(Class<?> payloadType) {
        this.payloadType = payloadType;
    }

    @Override
    @Nonnull
    public CompletableFuture<Object> resolveParameterValue(@Nonnull ProcessingContext context) {
        return CompletableFuture.completedFuture(Message.fromContext(context).payload());
    }

    @Override
    public boolean matches(@Nonnull ProcessingContext context) {
        return Optional.ofNullable(Message.fromContext(context)).map(Message::payloadType).map(this.payloadType::isAssignableFrom).orElse(false);
    }

    @Override
    public Class<?> supportedPayloadType() {
        return this.payloadType;
    }
}

