/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.messaging.core.DelayedMessageStream;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.annotation.AnnotatedHandlerAttributes;
import org.axonframework.messaging.core.annotation.HandlerAttributes;
import org.axonframework.messaging.core.annotation.MessageHandlerInvocationException;
import org.axonframework.messaging.core.annotation.MessageHandlingMember;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.annotation.UnsupportedHandlerException;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodInvokingMessageHandlingMember<T>
implements MessageHandlingMember<T> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Class<?> payloadType;
    private final int parameterCount;
    private final ParameterResolver<?>[] parameterResolvers;
    private final Function<Object, MessageStream<?>> returnTypeConverter;
    private final Method method;
    private final Class<? extends Message> messageType;
    private final HandlerAttributes attributes;

    public MethodInvokingMessageHandlingMember(Method method, Class<? extends Message> messageType, Class<?> explicitPayloadType, ParameterResolverFactory parameterResolverFactory, Function<Object, MessageStream<?>> returnTypeConverter) {
        this.messageType = messageType;
        this.method = (Method)ReflectionUtils.ensureAccessible((AccessibleObject)method);
        this.returnTypeConverter = returnTypeConverter;
        Parameter[] parameters = method.getParameters();
        this.parameterCount = method.getParameterCount();
        this.parameterResolvers = new ParameterResolver[this.parameterCount];
        Class<?> supportedPayloadType = explicitPayloadType;
        for (int i = 0; i < this.parameterCount; ++i) {
            this.parameterResolvers[i] = parameterResolverFactory.createInstance(method, parameters, i);
            if (this.parameterResolvers[i] == null) {
                throw new UnsupportedHandlerException("Unable to resolve parameter " + i + " (" + parameters[i].getType().getSimpleName() + ") in handler " + method.toGenericString() + ".", method);
            }
            if (supportedPayloadType.isAssignableFrom(this.parameterResolvers[i].supportedPayloadType())) {
                supportedPayloadType = this.parameterResolvers[i].supportedPayloadType();
                continue;
            }
            if (this.parameterResolvers[i].supportedPayloadType().isAssignableFrom(supportedPayloadType)) continue;
            throw new UnsupportedHandlerException(String.format("The method %s seems to have parameters that put conflicting requirements on the payload type applicable on that method: %s vs %s", method.toGenericString(), supportedPayloadType, this.parameterResolvers[i].supportedPayloadType()), method);
        }
        this.payloadType = supportedPayloadType;
        this.attributes = new AnnotatedHandlerAttributes(method);
    }

    @Override
    public Class<?> payloadType() {
        return this.payloadType;
    }

    @Override
    public boolean canHandle(@Nonnull Message message, @Nonnull ProcessingContext context) {
        ProcessingContext contextWithMessage = Message.addToContext(context, message);
        return this.typeMatches(message) && this.payloadType.isAssignableFrom(message.payloadType()) && this.parametersMatch(message, contextWithMessage);
    }

    @Override
    public boolean canHandleType(@Nonnull Class<?> payloadType) {
        return this.payloadType.isAssignableFrom(payloadType);
    }

    @Override
    public boolean canHandleMessageType(@Nonnull Class<? extends Message> messageType) {
        return this.messageType.isAssignableFrom(messageType);
    }

    protected boolean typeMatches(Message message) {
        return this.messageType.isInstance(message);
    }

    protected boolean parametersMatch(Message message, ProcessingContext processingContext) {
        for (ParameterResolver<?> resolver : this.parameterResolvers) {
            if (resolver.matches(processingContext)) continue;
            logger.debug("Parameter Resolver [{}] did not match message [{}] for payload type [{}].", new Object[]{resolver.getClass(), message, message.payloadType()});
            return false;
        }
        return true;
    }

    @Override
    public Object handleSync(@Nonnull Message message, @Nonnull ProcessingContext context, @Nullable T target) throws Exception {
        try {
            MessageStream.Entry<?> resultEntry = this.handle(message, context, target).first().asCompletableFuture().get();
            return resultEntry != null ? resultEntry.message().payload() : null;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof Exception) {
                Exception ex = (Exception)throwable;
                throw ex;
            }
            throw e;
        }
    }

    @Override
    public MessageStream<?> handle(@Nonnull Message message, @Nonnull ProcessingContext context, @Nullable T target) {
        CompletionStage invocationFuture;
        ProcessingContext contextWithMessage = Message.addToContext(context, message);
        CompletableFuture<Object[]> parametersFuture = this.resolveParameterValues(contextWithMessage);
        CompletionStage castedFuture = invocationFuture = parametersFuture.handle((params, throwable) -> {
            if (throwable != null) {
                logger.warn("Method [{}] failed handling message with identifier [{}].", (Object)this.method, (Object)message.identifier());
                return MessageStream.failed(throwable);
            }
            try {
                Object result = this.method.invoke(target, params);
                return this.returnTypeConverter.apply(result);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.warn("Method [{}] failed handling message with identifier [{}].", (Object)this.method, (Object)message.identifier());
                if (e.getCause() instanceof Exception) {
                    return MessageStream.failed(e.getCause());
                }
                if (e.getCause() instanceof Error) {
                    return MessageStream.failed(e.getCause());
                }
                return MessageStream.failed((Throwable)((Object)new MessageHandlerInvocationException(String.format("Error handling an object of type [%s]", this.messageType), e)));
            }
        });
        return DelayedMessageStream.create(castedFuture);
    }

    private CompletableFuture<Object[]> resolveParameterValues(ProcessingContext context) {
        CompletableFuture[] futures = (CompletableFuture[])Arrays.stream(this.parameterResolvers).map(resolver -> this.tryResolveParameterValue((ParameterResolver<?>)resolver, context)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(v -> Arrays.stream(futures).map(CompletableFuture::resultNow).toArray());
    }

    @Nonnull
    private CompletableFuture<?> tryResolveParameterValue(ParameterResolver<?> parameterResolver, ProcessingContext context) {
        try {
            return parameterResolver.resolveParameterValue(context);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    @Override
    public <R> Optional<R> attribute(String attributeKey) {
        return Optional.ofNullable(this.attributes.get(attributeKey));
    }

    @Override
    public <H> Optional<H> unwrap(Class<H> handlerType) {
        if (handlerType.isInstance(this)) {
            return Optional.of(this);
        }
        if (handlerType.isInstance(this.method)) {
            return Optional.of(this.method);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.method.toGenericString();
    }

    public int hashCode() {
        return Objects.hash(this.method);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInvokingMessageHandlingMember that = (MethodInvokingMessageHandlingMember)o;
        return this.method.equals(that.method);
    }
}

