/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.annotation;

import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.FutureUtils;
import org.axonframework.common.Priority;
import org.axonframework.messaging.core.LegacyResources;
import org.axonframework.messaging.core.annotation.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.messaging.core.annotation.AggregateType;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;

@Priority(value=0x3FFFFFFF)
public final class AggregateTypeParameterResolverFactory
extends AbstractAnnotatedParameterResolverFactory<AggregateType, String> {
    private final ParameterResolver<String> resolver = new AggregateTypeParameterResolver();

    public AggregateTypeParameterResolverFactory() {
        super(AggregateType.class, String.class);
    }

    @Override
    protected ParameterResolver<String> getResolver() {
        return this.resolver;
    }

    static class AggregateTypeParameterResolver
    implements ParameterResolver<String> {
        AggregateTypeParameterResolver() {
        }

        @Override
        @Nonnull
        public CompletableFuture<String> resolveParameterValue(@Nonnull ProcessingContext context) {
            String aggregateType = context.getResource(LegacyResources.AGGREGATE_TYPE_KEY);
            if (aggregateType != null) {
                return CompletableFuture.completedFuture(aggregateType);
            }
            return FutureUtils.emptyCompletedFuture();
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return context.containsResource(LegacyResources.AGGREGATE_TYPE_KEY);
        }
    }
}

