/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.common.annotation.Internal;
import org.axonframework.conversion.Converter;

@Internal
class ConversionCache {
    private final boolean conversionEnabled = Boolean.parseBoolean(System.getProperty("AXON_CONVERSION_CACHE_ENABLED", "true"));
    private static final Object NULL = new Object();
    private final ConcurrentHashMap<Target, Object> conversionCache;
    private final Object original;

    public ConversionCache(@Nullable Object original) {
        this.original = original;
        this.conversionCache = this.conversionEnabled ? new ConcurrentHashMap() : null;
    }

    @Nullable
    <T> T convertIfAbsent(@Nonnull Type targetType, @Nonnull Converter converter) {
        if (this.conversionEnabled) {
            return (T)this.unwrapNull(this.conversionCache.computeIfAbsent(new Target(targetType, converter), t -> this.wrapNull(converter.convert(this.original, targetType))));
        }
        return (T)converter.convert(this.original, targetType);
    }

    @Nonnull
    private Object wrapNull(@Nullable Object obj) {
        return obj == null ? NULL : obj;
    }

    @Nullable
    private Object unwrapNull(@Nonnull Object wrapped) {
        return wrapped == NULL ? null : wrapped;
    }

    private record Target(Type targetType, Converter converter) {
    }
}

