/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.commandhandling.interception;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.commandhandling.CommandBus;
import org.axonframework.messaging.commandhandling.CommandHandler;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.CommandResultMessage;
import org.axonframework.messaging.commandhandling.interception.CommandMessageHandlerInterceptorChain;
import org.axonframework.messaging.core.DefaultMessageDispatchInterceptorChain;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageDispatchInterceptor;
import org.axonframework.messaging.core.MessageHandlerInterceptor;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;

public class InterceptingCommandBus
implements CommandBus {
    public static final int DECORATION_ORDER = -2147483548;
    private final CommandBus delegate;
    private final List<MessageHandlerInterceptor<? super CommandMessage>> handlerInterceptors;
    private final List<MessageDispatchInterceptor<? super CommandMessage>> dispatchInterceptors;
    private final InterceptingDispatcher interceptingDispatcher;

    public InterceptingCommandBus(@Nonnull CommandBus delegate, @Nonnull List<MessageHandlerInterceptor<? super CommandMessage>> handlerInterceptors, @Nonnull List<MessageDispatchInterceptor<? super CommandMessage>> dispatchInterceptors) {
        this.delegate = Objects.requireNonNull(delegate, "The command bus delegate must be null.");
        this.handlerInterceptors = new ArrayList<MessageHandlerInterceptor<? super CommandMessage>>((Collection)Objects.requireNonNull(handlerInterceptors, "The handler interceptors must not be null."));
        this.dispatchInterceptors = new ArrayList<MessageDispatchInterceptor<? super CommandMessage>>((Collection)Objects.requireNonNull(dispatchInterceptors, "The dispatch interceptors must not be null."));
        this.interceptingDispatcher = new InterceptingDispatcher(dispatchInterceptors, this::dispatchCommand);
    }

    @Override
    public InterceptingCommandBus subscribe(@Nonnull QualifiedName name, @Nonnull CommandHandler commandHandler) {
        this.delegate.subscribe(name, (CommandHandler)new InterceptingHandler(commandHandler, this.handlerInterceptors));
        return this;
    }

    @Override
    public CompletableFuture<CommandResultMessage> dispatch(@Nonnull CommandMessage command, @Nullable ProcessingContext processingContext) {
        return this.interceptingDispatcher.interceptAndDispatch(command, processingContext);
    }

    private MessageStream<?> dispatchCommand(@Nonnull Message message, @Nullable ProcessingContext processingContext) {
        if (!(message instanceof CommandMessage)) {
            throw new IllegalArgumentException("Unsupported message implementation: " + String.valueOf(message));
        }
        CommandMessage command = (CommandMessage)message;
        return MessageStream.fromFuture(this.delegate.dispatch(command, processingContext));
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf((Object)this.delegate);
        descriptor.describeProperty("handlerInterceptors", this.handlerInterceptors);
        descriptor.describeProperty("dispatchInterceptors", this.dispatchInterceptors);
    }

    private static class InterceptingDispatcher {
        private final DefaultMessageDispatchInterceptorChain<? super CommandMessage> interceptorChain;

        private InterceptingDispatcher(List<MessageDispatchInterceptor<? super CommandMessage>> interceptors, BiFunction<? super CommandMessage, ProcessingContext, MessageStream<?>> dispatcher) {
            this.interceptorChain = new DefaultMessageDispatchInterceptorChain<CommandMessage>(interceptors, dispatcher);
        }

        private CompletableFuture<CommandResultMessage> interceptAndDispatch(@Nonnull CommandMessage command, @Nullable ProcessingContext context) {
            return this.interceptorChain.proceed(command, context).first().cast().asCompletableFuture().thenApply(entry -> entry == null ? null : (CommandResultMessage)entry.message());
        }
    }

    private static class InterceptingHandler
    implements CommandHandler {
        private final CommandMessageHandlerInterceptorChain interceptorChain;

        private InterceptingHandler(CommandHandler handler, List<MessageHandlerInterceptor<? super CommandMessage>> interceptors) {
            this.interceptorChain = new CommandMessageHandlerInterceptorChain(interceptors, handler);
        }

        @Override
        @Nonnull
        public MessageStream.Single<CommandResultMessage> handle(@Nonnull CommandMessage command, @Nonnull ProcessingContext context) {
            return this.interceptorChain.proceed(command, context).first().cast();
        }
    }
}

