/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.commandhandling.gateway;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.commandhandling.CommandBus;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.CommandPriorityCalculator;
import org.axonframework.messaging.commandhandling.GenericCommandMessage;
import org.axonframework.messaging.commandhandling.RoutingStrategy;
import org.axonframework.messaging.commandhandling.gateway.CommandGateway;
import org.axonframework.messaging.commandhandling.gateway.CommandResult;
import org.axonframework.messaging.commandhandling.gateway.FutureCommandResult;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageTypeResolver;
import org.axonframework.messaging.core.Metadata;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;

public class DefaultCommandGateway
implements CommandGateway {
    private final CommandBus commandBus;
    private final MessageTypeResolver messageTypeResolver;
    private final CommandPriorityCalculator priorityCalculator;
    private final RoutingStrategy routingKeyResolver;

    public DefaultCommandGateway(@Nonnull CommandBus commandBus, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull CommandPriorityCalculator priorityCalculator, @Nonnull RoutingStrategy routingKeyResolver) {
        this.commandBus = Objects.requireNonNull(commandBus, "The commandBus may not be null.");
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "The messageTypeResolver may not be null.");
        this.priorityCalculator = Objects.requireNonNull(priorityCalculator, "The CommandPriorityCalculator may not be null.");
        this.routingKeyResolver = Objects.requireNonNull(routingKeyResolver, "The RoutingStrategy may not be null.");
    }

    @Override
    @Nonnull
    public CommandResult send(@Nonnull Object command, @Nonnull Metadata metadata, @Nullable ProcessingContext context) {
        return new FutureCommandResult(this.commandBus.dispatch(this.asCommandMessage(command, metadata), context));
    }

    private CommandMessage asCommandMessage(Object command, Metadata metadata) {
        CommandMessage commandMessage;
        if (command instanceof CommandMessage) {
            commandMessage = (CommandMessage)command;
        } else {
            GenericCommandMessage genericCommandMessage;
            if (command instanceof Message) {
                Message message = (Message)command;
                genericCommandMessage = new GenericCommandMessage(message.type(), message.payload(), message.metadata());
            } else {
                genericCommandMessage = new GenericCommandMessage(this.messageTypeResolver.resolveOrThrow(command), command, metadata);
            }
            commandMessage = genericCommandMessage;
        }
        return new GenericCommandMessage(commandMessage, commandMessage.routingKey().orElse(this.routingKeyResolver.getRoutingKey(commandMessage)), commandMessage.priority().orElse(this.priorityCalculator.determinePriority(commandMessage)));
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("commandBus", (Object)this.commandBus);
        descriptor.describeProperty("messageTypeResolver", (Object)this.messageTypeResolver);
        descriptor.describeProperty("priorityCalculator", (Object)this.priorityCalculator);
        descriptor.describeProperty("routingKeyResolver", (Object)this.routingKeyResolver);
    }
}

