/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.commandhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Consumer;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.Module;
import org.axonframework.common.configuration.ModuleBuilder;
import org.axonframework.messaging.commandhandling.CommandHandler;
import org.axonframework.messaging.commandhandling.CommandHandlingComponent;
import org.axonframework.messaging.commandhandling.annotation.AnnotatedCommandHandlingComponent;
import org.axonframework.messaging.commandhandling.configuration.SimpleCommandHandlingModule;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.conversion.MessageConverter;

public interface CommandHandlingModule
extends Module,
ModuleBuilder<CommandHandlingModule> {
    public static SetupPhase named(@Nonnull String moduleName) {
        return new SimpleCommandHandlingModule(moduleName);
    }

    public static interface CommandHandlerPhase
    extends ModuleBuilder<CommandHandlingModule> {
        default public CommandHandlerPhase commandHandler(@Nonnull QualifiedName commandName, @Nonnull CommandHandler commandHandler) {
            Objects.requireNonNull(commandHandler, "The command handler cannot be null.");
            return this.commandHandler(commandName, (ComponentBuilder<CommandHandler>)((ComponentBuilder)cfg -> commandHandler));
        }

        public CommandHandlerPhase commandHandler(@Nonnull QualifiedName var1, @Nonnull ComponentBuilder<CommandHandler> var2);

        public CommandHandlerPhase commandHandlingComponent(@Nonnull ComponentBuilder<CommandHandlingComponent> var1);

        default public CommandHandlerPhase annotatedCommandHandlingComponent(@Nonnull ComponentBuilder<Object> handlingComponentBuilder) {
            Objects.requireNonNull(handlingComponentBuilder, "The handling component builder cannot be null.");
            return this.commandHandlingComponent((ComponentBuilder<CommandHandlingComponent>)((ComponentBuilder)c -> new AnnotatedCommandHandlingComponent<Object>(handlingComponentBuilder.build(c), (ParameterResolverFactory)c.getComponent(ParameterResolverFactory.class), (MessageConverter)c.getComponent(MessageConverter.class))));
        }
    }

    public static interface SetupPhase {
        public CommandHandlerPhase commandHandlers();

        default public CommandHandlerPhase commandHandlers(@Nonnull Consumer<CommandHandlerPhase> configurationLambda) {
            CommandHandlerPhase commandHandlerPhase = this.commandHandlers();
            Objects.requireNonNull(configurationLambda, "The command handler configuration lambda cannot be null.").accept(commandHandlerPhase);
            return commandHandlerPhase;
        }
    }
}

