/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.queryhandling.gateway;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.core.FluxUtils;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.MessageType;
import org.axonframework.messaging.core.MessageTypeResolver;
import org.axonframework.messaging.core.conversion.MessageConverter;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.queryhandling.GenericQueryMessage;
import org.axonframework.messaging.queryhandling.QueryBus;
import org.axonframework.messaging.queryhandling.QueryMessage;
import org.axonframework.messaging.queryhandling.QueryPriorityCalculator;
import org.axonframework.messaging.queryhandling.QueryResponseMessage;
import org.axonframework.messaging.queryhandling.gateway.QueryGateway;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.concurrent.Queues;

public class DefaultQueryGateway
implements QueryGateway {
    private final QueryBus queryBus;
    private final MessageTypeResolver messageTypeResolver;
    private final QueryPriorityCalculator priorityCalculator;
    private final MessageConverter converter;

    public DefaultQueryGateway(@Nonnull QueryBus queryBus, @Nonnull MessageTypeResolver messageTypeResolver, @Nonnull QueryPriorityCalculator priorityCalculator, @Nonnull MessageConverter converter) {
        this.queryBus = Objects.requireNonNull(queryBus, "The QueryBus must not be null.");
        this.messageTypeResolver = Objects.requireNonNull(messageTypeResolver, "The MessageTypeResolver must not be null.");
        this.priorityCalculator = Objects.requireNonNull(priorityCalculator, "The QueryPriorityCalculator must not be null.");
        this.converter = Objects.requireNonNull(converter, "The MessageConverter must not be null.");
    }

    @Override
    @Nonnull
    public <R> CompletableFuture<R> query(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context) {
        QueryMessage queryMessage = this.asQueryMessage(query);
        MessageStream<QueryResponseMessage> resultStream = this.queryBus.query(queryMessage, context);
        CompletionStage resultFuture = resultStream.first().asCompletableFuture().thenApply(entry -> {
            if (entry == null) {
                return null;
            }
            return ((QueryResponseMessage)entry.message()).payloadAs(responseType, (Converter)this.converter);
        });
        ((CompletableFuture)resultFuture).whenComplete((r, e) -> {
            if (!resultStream.isCompleted()) {
                resultStream.close();
            }
        });
        return resultFuture;
    }

    @Override
    @Nonnull
    public <R> CompletableFuture<List<R>> queryMany(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context) {
        QueryMessage queryMessage = this.asQueryMessage(query);
        MessageStream<QueryResponseMessage> resultStream = this.queryBus.query(queryMessage, context);
        CompletableFuture<List<R>> resultFuture = resultStream.reduce(new ArrayList(), (list, entry) -> {
            list.add(((QueryResponseMessage)entry.message()).payloadAs(responseType, (Converter)this.converter));
            return list;
        });
        resultFuture.whenComplete((r, e) -> {
            if (!resultStream.isCompleted()) {
                resultStream.close();
            }
        });
        return resultFuture;
    }

    @Override
    @Nonnull
    public <R> Publisher<R> streamingQuery(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context) {
        return Mono.fromSupplier(() -> this.asQueryMessage(query)).flatMapMany(queryMessage -> FluxUtils.of(this.queryBus.query((QueryMessage)queryMessage, context))).map(MessageStream.Entry::message).mapNotNull(m -> m.payloadAs(responseType, (Converter)this.converter));
    }

    @Override
    @Nonnull
    public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType) {
        return this.subscriptionQuery(query, (Class<T>)responseType, (Function)m -> m.payloadAs(responseType, (Converter)this.converter), (ProcessingContext)null, Queues.SMALL_BUFFER_SIZE);
    }

    @Override
    @Nonnull
    public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType, @Nullable ProcessingContext context, int updateBufferSize) {
        return this.subscriptionQuery(query, (Class<T>)responseType, (Function)m -> m.payloadAs(responseType, (Converter)this.converter), context, updateBufferSize);
    }

    @Override
    @Nonnull
    public <R> Publisher<R> subscriptionQuery(@Nonnull Object query, @Nonnull Class<R> responseType, int updateBufferSize) {
        return this.subscriptionQuery(query, (Class<T>)responseType, (Function)m -> m.payloadAs(responseType, (Converter)this.converter), (ProcessingContext)null, updateBufferSize);
    }

    @Nonnull
    public <T> Publisher<T> subscriptionQuery(@Nonnull Object query, @Nonnull Class<T> responseType, @Nonnull Function<QueryResponseMessage, T> mapper, @Nullable ProcessingContext context, int updateBufferSize) {
        QueryMessage queryMessage = this.asQueryMessage(query);
        MessageStream<QueryResponseMessage> response = this.queryBus.subscriptionQuery(queryMessage, context, updateBufferSize);
        return FluxUtils.of(response).mapNotNull(m -> mapper.apply((QueryResponseMessage)m.message())).doOnCancel(response::close).doOnError(e -> response.close());
    }

    private QueryMessage asQueryMessage(Object query) {
        GenericQueryMessage genericQueryMessage;
        if (query instanceof QueryMessage) {
            QueryMessage queryMessage = (QueryMessage)query;
            return queryMessage;
        }
        if (query instanceof Message) {
            Message message = (Message)query;
            genericQueryMessage = new GenericQueryMessage(message);
        } else {
            genericQueryMessage = new GenericQueryMessage(this.resolveTypeFor(query), query);
        }
        return genericQueryMessage;
    }

    private MessageType resolveTypeFor(Object payload) {
        return this.messageTypeResolver.resolveOrThrow(payload);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("queryBus", (Object)this.queryBus);
        descriptor.describeProperty("messageTypeResolver", (Object)this.messageTypeResolver);
        descriptor.describeProperty("priorityCalculator", (Object)this.priorityCalculator);
    }
}

