/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.queryhandling.distributed;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.AxonThreadFactory;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.util.ExecutorServiceFactory;

public record DistributedQueryBusConfiguration(int queryThreads, @Nonnull ExecutorServiceFactory<DistributedQueryBusConfiguration> queryExecutorServiceFactory, int queryResponseThreads, @Nonnull ExecutorServiceFactory<DistributedQueryBusConfiguration> queryResponseExecutorServiceFactory) {
    private static final int DEFAULT_QUERY_THREADS = 10;
    private static final int DEFAULT_RESPONSE_THREADS = 5;
    private static final ExecutorServiceFactory<DistributedQueryBusConfiguration> DEFAULT_QUERY_EXECUTOR_SERVICE_FACTORY = (configuration, queryProcessQueue) -> new ThreadPoolExecutor(configuration.queryThreads(), configuration.queryThreads(), 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)queryProcessQueue, (ThreadFactory)new AxonThreadFactory("QueryProcessor"));
    private static final ExecutorServiceFactory<DistributedQueryBusConfiguration> DEFAULT_RESPONSE_EXECUTOR_SERVICE_FACTORY = (configuration, queryProcessQueue) -> new ThreadPoolExecutor(configuration.queryThreads(), configuration.queryThreads(), 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)queryProcessQueue, (ThreadFactory)new AxonThreadFactory("QueryResponseProcessor"));
    public static final DistributedQueryBusConfiguration DEFAULT = new DistributedQueryBusConfiguration(10, DEFAULT_QUERY_EXECUTOR_SERVICE_FACTORY, 5, DEFAULT_RESPONSE_EXECUTOR_SERVICE_FACTORY);

    public DistributedQueryBusConfiguration {
        BuilderUtils.assertStrictPositive((int)queryThreads, (String)"Number of query threads must be greater than 0.");
        BuilderUtils.assertStrictPositive((int)queryResponseThreads, (String)"Number of query response handling threads must be greater than 0.");
    }

    public DistributedQueryBusConfiguration queryThreads(int queryThreads) {
        return new DistributedQueryBusConfiguration(queryThreads, this.queryExecutorServiceFactory, this.queryResponseThreads, this.queryResponseExecutorServiceFactory);
    }

    public DistributedQueryBusConfiguration queryExecutorService(@Nonnull ExecutorService executorService) {
        Objects.requireNonNull(executorService, "The ExecutorService may not be null.");
        return new DistributedQueryBusConfiguration(this.queryThreads, (ExecutorServiceFactory<DistributedQueryBusConfiguration>)((ExecutorServiceFactory)(config, queue) -> executorService), this.queryResponseThreads, this.queryResponseExecutorServiceFactory);
    }

    public DistributedQueryBusConfiguration queryResponseThreads(int queryResponseThreads) {
        return new DistributedQueryBusConfiguration(this.queryThreads, this.queryExecutorServiceFactory, queryResponseThreads, this.queryResponseExecutorServiceFactory);
    }

    public DistributedQueryBusConfiguration queryResponseExecutorService(@Nonnull ExecutorService executorService) {
        Objects.requireNonNull(executorService, "The ExecutorService may not be null.");
        return new DistributedQueryBusConfiguration(this.queryThreads, this.queryExecutorServiceFactory, this.queryResponseThreads, (ExecutorServiceFactory<DistributedQueryBusConfiguration>)((ExecutorServiceFactory)(config, queue) -> executorService));
    }
}

