/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.queryhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Consumer;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.Module;
import org.axonframework.common.configuration.ModuleBuilder;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.conversion.MessageConverter;
import org.axonframework.messaging.queryhandling.QueryHandler;
import org.axonframework.messaging.queryhandling.QueryHandlingComponent;
import org.axonframework.messaging.queryhandling.annotation.AnnotatedQueryHandlingComponent;
import org.axonframework.messaging.queryhandling.configuration.SimpleQueryHandlingModule;

public interface QueryHandlingModule
extends Module,
ModuleBuilder<QueryHandlingModule> {
    public static SetupPhase named(@Nonnull String moduleName) {
        return new SimpleQueryHandlingModule(moduleName);
    }

    public static interface QueryHandlerPhase
    extends ModuleBuilder<QueryHandlingModule> {
        default public QueryHandlerPhase queryHandler(@Nonnull QualifiedName queryName, @Nonnull QueryHandler queryHandler) {
            Objects.requireNonNull(queryHandler, "The query handler cannot be null.");
            return this.queryHandler(queryName, (ComponentBuilder<QueryHandler>)((ComponentBuilder)c -> queryHandler));
        }

        public QueryHandlerPhase queryHandler(@Nonnull QualifiedName var1, @Nonnull ComponentBuilder<QueryHandler> var2);

        public QueryHandlerPhase queryHandlingComponent(@Nonnull ComponentBuilder<QueryHandlingComponent> var1);

        default public QueryHandlerPhase annotatedQueryHandlingComponent(@Nonnull ComponentBuilder<Object> handlingComponentBuilder) {
            Objects.requireNonNull(handlingComponentBuilder, "The handling component builder cannot be null.");
            return this.queryHandlingComponent((ComponentBuilder<QueryHandlingComponent>)((ComponentBuilder)c -> new AnnotatedQueryHandlingComponent<Object>(handlingComponentBuilder.build(c), (ParameterResolverFactory)c.getComponent(ParameterResolverFactory.class), ClasspathHandlerDefinition.forClass(c.getClass()), (MessageConverter)c.getComponent(MessageConverter.class))));
        }
    }

    public static interface SetupPhase {
        public QueryHandlerPhase queryHandlers();

        default public QueryHandlerPhase queryHandlers(@Nonnull Consumer<QueryHandlerPhase> configurationLambda) {
            QueryHandlerPhase queryHandlerPhase = this.queryHandlers();
            configurationLambda.accept(queryHandlerPhase);
            return queryHandlerPhase;
        }
    }
}

