/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.queryhandling.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.util.ClasspathResolver;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.annotation.HandlerEnhancerDefinition;
import org.axonframework.messaging.core.annotation.MessageHandlingMember;
import org.axonframework.messaging.core.annotation.UnsupportedHandlerException;
import org.axonframework.messaging.core.annotation.WrappedMessageHandlingMember;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.queryhandling.QueryMessage;
import org.axonframework.messaging.queryhandling.annotation.QueryHandlingMember;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MethodQueryHandlerDefinition
implements HandlerEnhancerDefinition {
    @Override
    @Nonnull
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        return original.attribute("QueryHandler.queryName").map(queryName -> new MethodQueryHandlingMember(original, (String)queryName)).orElse(original);
    }

    private static class MethodQueryHandlingMember<T>
    extends WrappedMessageHandlingMember<T>
    implements QueryHandlingMember<T> {
        private final String queryName;
        private final Type resultType;

        public MethodQueryHandlingMember(MessageHandlingMember<T> original, String queryNameAttribute) {
            super(original);
            if ("".equals(queryNameAttribute)) {
                queryNameAttribute = original.payloadType().getName();
            }
            this.queryName = queryNameAttribute;
            this.resultType = original.unwrap(Method.class).map(this::queryResultType).orElseThrow(() -> new UnsupportedHandlerException("@QueryHandler annotation can only be put on methods.", original.unwrap(Member.class).orElse(null)));
            if (Void.TYPE.equals(this.resultType)) {
                throw new UnsupportedHandlerException("@QueryHandler annotated methods must not declare void return type", original.unwrap(Member.class).orElse(null));
            }
        }

        @Override
        public Object handleSync(@Nonnull Message message, @Nonnull ProcessingContext context, @Nullable T target) throws Exception {
            Object result = super.handleSync(message, context, target);
            if (result instanceof Optional) {
                return ((Optional)result).orElse(null);
            }
            return result;
        }

        private Type queryResultType(Method method) {
            if (Void.class.equals(method.getReturnType())) {
                throw new UnsupportedHandlerException("@QueryHandler annotated methods must not declare void return type", method);
            }
            return this.unwrapType(method.getGenericReturnType());
        }

        private Type unwrapType(Type genericReturnType) {
            ArrayList<Class<Stream>> typeToUnwrap = new ArrayList<Class<Stream>>(List.of(Future.class, Optional.class, Publisher.class, Iterable.class, Stream.class));
            if (ClasspathResolver.projectReactorOnClasspath()) {
                typeToUnwrap.addAll(List.of(Flux.class, Mono.class));
            }
            return this.upperBound(ReflectionUtils.resolvePrimitiveWrapperTypeIfPrimitive((Type)ReflectionUtils.unwrapIfType((Type)genericReturnType, (Class[])typeToUnwrap.toArray(new Class[0]))));
        }

        private Type upperBound(Type type) {
            if (type instanceof WildcardType) {
                if (((WildcardType)type).getUpperBounds().length == 1) {
                    return ((WildcardType)type).getUpperBounds()[0];
                }
                return Object.class;
            }
            return type;
        }

        @Override
        public boolean canHandle(@Nonnull Message message, @Nonnull ProcessingContext context) {
            return super.canHandle(message, context) && message instanceof QueryMessage && this.queryName.equals(message.type().name());
        }

        @Override
        public String queryName() {
            return this.queryName;
        }

        @Override
        public Type resultType() {
            return this.resultType;
        }
    }
}

