/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.queryhandling.annotation;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.axonframework.conversion.Converter;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageStream;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.annotation.AnnotatedHandlerInspector;
import org.axonframework.messaging.core.annotation.ClasspathHandlerDefinition;
import org.axonframework.messaging.core.annotation.ClasspathParameterResolverFactory;
import org.axonframework.messaging.core.annotation.HandlerDefinition;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.conversion.MessageConverter;
import org.axonframework.messaging.core.interception.annotation.MessageHandlerInterceptorMemberChain;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.queryhandling.GenericQueryResponseMessage;
import org.axonframework.messaging.queryhandling.QueryExecutionException;
import org.axonframework.messaging.queryhandling.QueryHandler;
import org.axonframework.messaging.queryhandling.QueryHandlingComponent;
import org.axonframework.messaging.queryhandling.QueryMessage;
import org.axonframework.messaging.queryhandling.QueryResponseMessage;
import org.axonframework.messaging.queryhandling.SimpleQueryHandlingComponent;
import org.axonframework.messaging.queryhandling.annotation.QueryHandlingMember;

public class AnnotatedQueryHandlingComponent<T>
implements QueryHandlingComponent {
    private final SimpleQueryHandlingComponent handlingComponent;
    private final T target;
    private final AnnotatedHandlerInspector<T> model;
    private final MessageConverter converter;

    public AnnotatedQueryHandlingComponent(@Nonnull T annotatedQueryHandler, @Nonnull MessageConverter converter) {
        this(annotatedQueryHandler, ClasspathParameterResolverFactory.forClass(annotatedQueryHandler.getClass()), converter);
    }

    public AnnotatedQueryHandlingComponent(@Nonnull T annotatedQueryHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull MessageConverter converter) {
        this(annotatedQueryHandler, parameterResolverFactory, ClasspathHandlerDefinition.forClass(annotatedQueryHandler.getClass()), converter);
    }

    public AnnotatedQueryHandlingComponent(@Nonnull T annotatedQueryHandler, @Nonnull ParameterResolverFactory parameterResolverFactory, @Nonnull HandlerDefinition handlerDefinition, @Nonnull MessageConverter converter) {
        this.handlingComponent = SimpleQueryHandlingComponent.create("AnnotatedQueryHandlingComponent[%s]".formatted(annotatedQueryHandler.getClass().getName()));
        this.target = Objects.requireNonNull(annotatedQueryHandler, "The Annotated Query Handler may not be null.");
        this.model = AnnotatedHandlerInspector.inspectType(annotatedQueryHandler.getClass(), parameterResolverFactory, handlerDefinition);
        this.converter = Objects.requireNonNull(converter, "The Converter may not be null.");
        this.initializeHandlersBasedOnModel();
    }

    private void initializeHandlersBasedOnModel() {
        this.model.getAllHandlers().forEach((modelClass, handlers) -> handlers.stream().filter(handler -> handler.canHandleMessageType(QueryMessage.class)).filter(handler -> handler.unwrap(QueryHandlingMember.class).isPresent()).map(handler -> handler.unwrap(QueryHandlingMember.class).get()).forEach(this::registerHandler));
    }

    private void registerHandler(QueryHandlingMember<? super T> handler) {
        QualifiedName queryName = new QualifiedName(handler.queryName());
        this.handlingComponent.subscribe(queryName, this.constructQueryHandlerFor(handler));
    }

    private QueryHandler constructQueryHandlerFor(QueryHandlingMember<? super T> handler) {
        MessageHandlerInterceptorMemberChain<T> interceptorChain = this.model.chainedInterceptor(this.target.getClass());
        return (query, context) -> {
            MessageStream<QueryResponseMessage> resultStream = interceptorChain.handle(query.withConvertedPayload((Class)handler.payloadType(), (Converter)this.converter), context, this.target, handler).mapMessage(this::asQueryResponseMessage);
            Optional<Throwable> handlingException = resultStream.error();
            if (handlingException.isPresent() && !(handlingException.get() instanceof QueryExecutionException)) {
                return MessageStream.failed((Throwable)((Object)new QueryExecutionException("Handling query with identifier [" + query.identifier() + "] failed.", handlingException.get())));
            }
            return resultStream;
        };
    }

    private QueryResponseMessage asQueryResponseMessage(@Nonnull Message queryResponse) {
        return queryResponse instanceof QueryResponseMessage ? (QueryResponseMessage)queryResponse : new GenericQueryResponseMessage(queryResponse);
    }

    @Override
    @Nonnull
    public MessageStream<QueryResponseMessage> handle(@Nonnull QueryMessage query, @Nonnull ProcessingContext context) {
        return this.handlingComponent.handle(query, context);
    }

    @Override
    public Set<QualifiedName> supportedQueries() {
        return Set.copyOf(this.handlingComponent.supportedQueries());
    }
}

