/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventstreaming;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;
import org.axonframework.messaging.eventstreaming.EventCriteria;
import org.axonframework.messaging.eventstreaming.EventTypeRestrictableEventCriteria;
import org.axonframework.messaging.eventstreaming.EventTypeRestrictableOrEventCriteria;
import org.axonframework.messaging.eventstreaming.Tag;
import org.axonframework.messaging.eventstreaming.TagFilteredEventCriteria;

public final class OrEventCriteriaBuilder {
    private final EventCriteria orCriteria;

    OrEventCriteriaBuilder(@Nonnull EventCriteria orCriteria) {
        this.orCriteria = Objects.requireNonNull(orCriteria, "orCriteria may not be null");
    }

    public EventTypeRestrictableEventCriteria havingTags(@Nonnull Set<Tag> tags) {
        return this.wrap(EventCriteria.havingTags(tags));
    }

    public EventTypeRestrictableEventCriteria havingTags(Tag ... tags) {
        return this.wrap(EventCriteria.havingTags(tags));
    }

    public EventTypeRestrictableEventCriteria havingTags(String ... tags) {
        return this.wrap(EventCriteria.havingTags(tags));
    }

    public EventTypeRestrictableEventCriteria havingAnyTag() {
        TagFilteredEventCriteria filteredEventCriteria = new TagFilteredEventCriteria(Set.of());
        return this.wrap(filteredEventCriteria);
    }

    private EventTypeRestrictableEventCriteria wrap(EventTypeRestrictableEventCriteria criteria) {
        return new EventTypeRestrictableOrEventCriteria(criteria, this.orCriteria);
    }
}

