/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.processing.streaming.token.annotation;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.concurrent.CompletableFuture;
import org.axonframework.messaging.core.annotation.ParameterResolver;
import org.axonframework.messaging.core.annotation.ParameterResolverFactory;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.processing.streaming.token.TrackingToken;
import org.axonframework.messaging.eventhandling.processing.streaming.token.WrappedToken;

public class TrackingTokenParameterResolverFactory
implements ParameterResolverFactory {
    private static final TrackingTokenParameterResolver RESOLVER = new TrackingTokenParameterResolver();

    @Nullable
    public ParameterResolver<TrackingToken> createInstance(@Nonnull Executable executable, @Nonnull Parameter[] parameters, int parameterIndex) {
        if (TrackingToken.class.equals(parameters[parameterIndex].getType())) {
            return RESOLVER;
        }
        return null;
    }

    private static class TrackingTokenParameterResolver
    implements ParameterResolver<TrackingToken> {
        private TrackingTokenParameterResolver() {
        }

        @Override
        @Nonnull
        public CompletableFuture<TrackingToken> resolveParameterValue(@Nonnull ProcessingContext context) {
            return CompletableFuture.completedFuture(TrackingToken.fromContext(context).map(this::unwrap).orElse(null));
        }

        private TrackingToken unwrap(TrackingToken trackingToken) {
            return WrappedToken.unwrapLowerBound(trackingToken);
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return context.containsResource(TrackingToken.RESOURCE_KEY);
        }
    }
}

