/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling.configuration;

import jakarta.annotation.Nonnull;
import java.util.List;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.ConfigurationEnhancer;
import org.axonframework.messaging.core.MessageDispatchInterceptor;
import org.axonframework.messaging.core.interception.DispatchInterceptorRegistry;
import org.axonframework.messaging.eventhandling.EventBus;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.eventhandling.InterceptingEventBus;
import org.axonframework.messaging.eventhandling.SimpleEventBus;

public class EventBusConfigurationDefaults
implements ConfigurationEnhancer {
    public static final int ENHANCER_ORDER = Integer.MAX_VALUE;

    public int order() {
        return Integer.MAX_VALUE;
    }

    public void enhance(@Nonnull ComponentRegistry registry) {
        EventBusConfigurationDefaults.registerComponents(registry);
        EventBusConfigurationDefaults.registerDecorators(registry);
    }

    private static void registerComponents(@Nonnull ComponentRegistry registry) {
        registry.registerIfNotPresent(EventBus.class, EventBusConfigurationDefaults::defaultEventBus);
    }

    private static EventBus defaultEventBus(Configuration config) {
        return new SimpleEventBus();
    }

    private static void registerDecorators(@Nonnull ComponentRegistry registry) {
        registry.registerDecorator(EventBus.class, -2147483548, (config, name, delegate) -> {
            List<MessageDispatchInterceptor<? super EventMessage>> dispatchInterceptors = ((DispatchInterceptorRegistry)config.getComponent(DispatchInterceptorRegistry.class)).eventInterceptors(config);
            return dispatchInterceptors.isEmpty() ? delegate : new InterceptingEventBus((EventBus)delegate, dispatchInterceptors);
        });
    }
}

