/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.eventhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import org.axonframework.common.Registration;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;
import org.axonframework.messaging.eventhandling.EventBus;
import org.axonframework.messaging.eventhandling.EventMessage;

@Internal
public abstract class DelegatingEventBus
implements EventBus {
    protected final EventBus delegate;

    public DelegatingEventBus(@Nonnull EventBus delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Delegate EventBus may not be null");
    }

    @Override
    public CompletableFuture<Void> publish(@Nullable ProcessingContext context, @Nonnull List<EventMessage> events) {
        return this.delegate.publish(context, events);
    }

    @Override
    public Registration subscribe(@Nonnull BiFunction<List<? extends EventMessage>, ProcessingContext, CompletableFuture<?>> eventsBatchConsumer) {
        return this.delegate.subscribe(eventsBatchConsumer);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        this.delegate.describeTo(descriptor);
    }
}

