/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.unitofwork;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Function;
import org.axonframework.messaging.core.ApplicationContext;
import org.axonframework.messaging.core.unitofwork.UnitOfWork;
import org.axonframework.messaging.core.unitofwork.UnitOfWorkConfiguration;
import org.axonframework.messaging.core.unitofwork.UnitOfWorkFactory;

public class SimpleUnitOfWorkFactory
implements UnitOfWorkFactory {
    private final ApplicationContext applicationContext;
    private final Function<UnitOfWorkConfiguration, UnitOfWorkConfiguration> factoryCustomization;

    public SimpleUnitOfWorkFactory(@Nonnull ApplicationContext applicationContext) {
        this(applicationContext, c -> c);
    }

    public SimpleUnitOfWorkFactory(@Nonnull ApplicationContext applicationContext, @Nonnull Function<UnitOfWorkConfiguration, UnitOfWorkConfiguration> factoryCustomization) {
        Objects.requireNonNull(applicationContext, "The applicationContext may not be null.");
        Objects.requireNonNull(factoryCustomization, "The factoryCustomization may not be null.");
        this.applicationContext = applicationContext;
        this.factoryCustomization = factoryCustomization;
    }

    @Override
    @Nonnull
    public UnitOfWork create(@Nonnull String identifier, @Nonnull Function<UnitOfWorkConfiguration, UnitOfWorkConfiguration> customization) {
        Objects.requireNonNull(identifier, "The identifier may not be null.");
        Objects.requireNonNull(customization, "The customization may not be null.");
        UnitOfWorkConfiguration configuration = customization.apply(this.factoryCustomization.apply(UnitOfWorkConfiguration.defaultValues()));
        return new UnitOfWork(identifier, configuration.workScheduler(), !configuration.allowAsyncProcessing(), this.applicationContext);
    }
}

