/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.core.interception;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import org.axonframework.common.TypeReference;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.configuration.Component;
import org.axonframework.common.configuration.ComponentBuilder;
import org.axonframework.common.configuration.ComponentDefinition;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.LazyInitializedComponentDefinition;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.core.Message;
import org.axonframework.messaging.core.MessageDispatchInterceptor;
import org.axonframework.messaging.core.interception.DispatchInterceptorRegistry;
import org.axonframework.messaging.eventhandling.EventMessage;
import org.axonframework.messaging.queryhandling.QueryMessage;
import org.axonframework.messaging.queryhandling.SubscriptionQueryUpdateMessage;

@Internal
public class DefaultDispatchInterceptorRegistry
implements DispatchInterceptorRegistry {
    private static final TypeReference<MessageDispatchInterceptor<Message>> INTERCEPTOR_TYPE_REF = new TypeReference<MessageDispatchInterceptor<Message>>(){};
    private static final TypeReference<MessageDispatchInterceptor<? super CommandMessage>> COMMAND_INTERCEPTOR_TYPE_REF = new TypeReference<MessageDispatchInterceptor<? super CommandMessage>>(){};
    private static final TypeReference<MessageDispatchInterceptor<? super EventMessage>> EVENT_INTERCEPTOR_TYPE_REF = new TypeReference<MessageDispatchInterceptor<? super EventMessage>>(){};
    private static final TypeReference<MessageDispatchInterceptor<? super QueryMessage>> QUERY_INTERCEPTOR_TYPE_REF = new TypeReference<MessageDispatchInterceptor<? super QueryMessage>>(){};
    private static final TypeReference<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>> SUBSCRIPTION_QUERY_UPDATE_INTERCEPTOR_TYPE_REF = new TypeReference<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>>(){};
    private final List<ComponentDefinition<MessageDispatchInterceptor<? super CommandMessage>>> commandInterceptorDefinitions = new ArrayList<ComponentDefinition<MessageDispatchInterceptor<? super CommandMessage>>>();
    private final List<ComponentDefinition<MessageDispatchInterceptor<? super EventMessage>>> eventInterceptorDefinitions = new ArrayList<ComponentDefinition<MessageDispatchInterceptor<? super EventMessage>>>();
    private final List<ComponentDefinition<MessageDispatchInterceptor<? super QueryMessage>>> queryInterceptorDefinitions = new ArrayList<ComponentDefinition<MessageDispatchInterceptor<? super QueryMessage>>>();
    private final List<ComponentDefinition<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>>> subscriptionQueryUpdateInterceptorDefinitions = new ArrayList<ComponentDefinition<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>>>();

    @Override
    @Nonnull
    public DispatchInterceptorRegistry registerInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<Message>> interceptorBuilder) {
        GenericInterceptorDefinition genericInterceptorDef = new GenericInterceptorDefinition(interceptorBuilder);
        this.registerCommandInterceptor((ComponentBuilder<MessageDispatchInterceptor<? super CommandMessage>>)((ComponentBuilder)config -> {
            MessageDispatchInterceptor genericInterceptor = (MessageDispatchInterceptor)genericInterceptorDef.doResolve(config);
            return (message, context, chain) -> genericInterceptor.interceptOnDispatch(message, context, (m, c) -> chain.proceed((CommandMessage)m, c));
        }));
        this.registerEventInterceptor((ComponentBuilder<MessageDispatchInterceptor<? super EventMessage>>)((ComponentBuilder)config -> {
            MessageDispatchInterceptor genericInterceptor = (MessageDispatchInterceptor)genericInterceptorDef.doResolve(config);
            return (message, context, chain) -> genericInterceptor.interceptOnDispatch(message, context, (m, c) -> chain.proceed((EventMessage)m, c));
        }));
        this.registerQueryInterceptor((ComponentBuilder<MessageDispatchInterceptor<? super QueryMessage>>)((ComponentBuilder)config -> {
            MessageDispatchInterceptor genericInterceptor = (MessageDispatchInterceptor)genericInterceptorDef.doResolve(config);
            return (message, context, chain) -> genericInterceptor.interceptOnDispatch(message, context, (m, c) -> chain.proceed((QueryMessage)m, c));
        }));
        this.registerSubscriptionQueryUpdateInterceptor((ComponentBuilder<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>>)((ComponentBuilder)config -> {
            MessageDispatchInterceptor genericInterceptor = (MessageDispatchInterceptor)genericInterceptorDef.doResolve(config);
            return (message, context, chain) -> genericInterceptor.interceptOnDispatch(message, context, (m, c) -> chain.proceed((SubscriptionQueryUpdateMessage)m, c));
        }));
        return this;
    }

    @Override
    @Nonnull
    public DispatchInterceptorRegistry registerCommandInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<? super CommandMessage>> interceptorBuilder) {
        this.commandInterceptorDefinitions.add((ComponentDefinition<MessageDispatchInterceptor<? super CommandMessage>>)ComponentDefinition.ofType(COMMAND_INTERCEPTOR_TYPE_REF).withBuilder(interceptorBuilder));
        return this;
    }

    @Override
    @Nonnull
    public DispatchInterceptorRegistry registerEventInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<? super EventMessage>> interceptorBuilder) {
        this.eventInterceptorDefinitions.add((ComponentDefinition<MessageDispatchInterceptor<? super EventMessage>>)ComponentDefinition.ofType(EVENT_INTERCEPTOR_TYPE_REF).withBuilder(interceptorBuilder));
        return this;
    }

    @Override
    @Nonnull
    public DispatchInterceptorRegistry registerQueryInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<? super QueryMessage>> interceptorBuilder) {
        this.queryInterceptorDefinitions.add((ComponentDefinition<MessageDispatchInterceptor<? super QueryMessage>>)ComponentDefinition.ofType(QUERY_INTERCEPTOR_TYPE_REF).withBuilder(interceptorBuilder));
        return this;
    }

    @Override
    @Nonnull
    public DispatchInterceptorRegistry registerSubscriptionQueryUpdateInterceptor(@Nonnull ComponentBuilder<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>> interceptorBuilder) {
        this.subscriptionQueryUpdateInterceptorDefinitions.add((ComponentDefinition<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>>)ComponentDefinition.ofType(SUBSCRIPTION_QUERY_UPDATE_INTERCEPTOR_TYPE_REF).withBuilder(interceptorBuilder));
        return this;
    }

    @Override
    @Nonnull
    public List<MessageDispatchInterceptor<? super CommandMessage>> commandInterceptors(@Nonnull Configuration config) {
        return DefaultDispatchInterceptorRegistry.resolveInterceptors(this.commandInterceptorDefinitions, config);
    }

    @Override
    @Nonnull
    public List<MessageDispatchInterceptor<? super EventMessage>> eventInterceptors(@Nonnull Configuration config) {
        return DefaultDispatchInterceptorRegistry.resolveInterceptors(this.eventInterceptorDefinitions, config);
    }

    @Override
    @Nonnull
    public List<MessageDispatchInterceptor<? super QueryMessage>> queryInterceptors(@Nonnull Configuration config) {
        return DefaultDispatchInterceptorRegistry.resolveInterceptors(this.queryInterceptorDefinitions, config);
    }

    @Override
    @Nonnull
    public List<MessageDispatchInterceptor<? super SubscriptionQueryUpdateMessage>> subscriptionQueryUpdateInterceptors(@Nonnull Configuration config) {
        return DefaultDispatchInterceptorRegistry.resolveInterceptors(this.subscriptionQueryUpdateInterceptorDefinitions, config);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("commandDispatchInterceptors", this.commandInterceptorDefinitions);
        descriptor.describeProperty("eventDispatchInterceptors", this.eventInterceptorDefinitions);
        descriptor.describeProperty("queryDispatchInterceptors", this.queryInterceptorDefinitions);
        descriptor.describeProperty("subscriptionQueryUpdateDispatchInterceptors", this.subscriptionQueryUpdateInterceptorDefinitions);
    }

    private static <T extends Message> List<MessageDispatchInterceptor<? super T>> resolveInterceptors(List<ComponentDefinition<MessageDispatchInterceptor<? super T>>> definitions, Configuration config) {
        ArrayList<MessageDispatchInterceptor<T>> dispatchInterceptors = new ArrayList<MessageDispatchInterceptor<T>>();
        for (ComponentDefinition<MessageDispatchInterceptor<T>> componentDefinition : definitions) {
            if (!(componentDefinition instanceof ComponentDefinition.ComponentCreator)) {
                throw new IllegalArgumentException("Unsupported component definition type: " + String.valueOf(componentDefinition));
            }
            ComponentDefinition.ComponentCreator creator = (ComponentDefinition.ComponentCreator)componentDefinition;
            MessageDispatchInterceptor dispatchInterceptor = (MessageDispatchInterceptor)creator.createComponent().resolve(config);
            dispatchInterceptors.add(dispatchInterceptor);
        }
        return dispatchInterceptors;
    }

    private static class GenericInterceptorDefinition
    extends LazyInitializedComponentDefinition<MessageDispatchInterceptor<Message>, MessageDispatchInterceptor<Message>> {
        public GenericInterceptorDefinition(ComponentBuilder<MessageDispatchInterceptor<Message>> builder) {
            super(new Component.Identifier(INTERCEPTOR_TYPE_REF, null), builder);
        }
    }
}

