/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.commandhandling.distributed;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.commandhandling.CommandMessage;
import org.axonframework.messaging.commandhandling.CommandResultMessage;
import org.axonframework.messaging.commandhandling.distributed.CommandBusConnector;
import org.axonframework.messaging.core.QualifiedName;
import org.axonframework.messaging.core.unitofwork.ProcessingContext;

public abstract class DelegatingCommandBusConnector
implements CommandBusConnector {
    protected final CommandBusConnector delegate;

    protected DelegatingCommandBusConnector(@Nonnull CommandBusConnector delegate) {
        this.delegate = Objects.requireNonNull(delegate, "The delegate must not be null.");
    }

    @Override
    @Nonnull
    public CompletableFuture<CommandResultMessage> dispatch(@Nonnull CommandMessage command, @Nullable ProcessingContext processingContext) {
        return this.delegate.dispatch(command, processingContext);
    }

    @Override
    public CompletableFuture<Void> subscribe(@Nonnull QualifiedName commandName, int loadFactor) {
        return this.delegate.subscribe(commandName, loadFactor);
    }

    @Override
    public boolean unsubscribe(@Nonnull QualifiedName commandName) {
        return this.delegate.unsubscribe(commandName);
    }

    @Override
    public void onIncomingCommand(@Nonnull CommandBusConnector.Handler handler) {
        this.delegate.onIncomingCommand(handler);
    }

    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeWrapperOf((Object)this.delegate);
    }
}

