/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.configuration;

import jakarta.annotation.Nonnull;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.axonframework.common.annotations.Internal;
import org.axonframework.updates.configuration.UsagePropertyProvider;

@Internal
public class HierarchicalUsagePropertyProvider
implements UsagePropertyProvider {
    private final List<UsagePropertyProvider> providers;

    public HierarchicalUsagePropertyProvider(@Nonnull List<UsagePropertyProvider> providers) {
        Objects.requireNonNull(providers, "The providers may not be null.");
        this.providers = providers.stream().sorted(Comparator.comparingInt(UsagePropertyProvider::priority).reversed()).toList();
    }

    @Override
    public Boolean getDisabled() {
        return this.providers.stream().map(UsagePropertyProvider::getDisabled).filter(Objects::nonNull).findFirst().orElse(false);
    }

    @Override
    public String getUrl() {
        return this.providers.stream().map(UsagePropertyProvider::getUrl).filter(Objects::nonNull).findFirst().orElse("");
    }

    @Override
    public int priority() {
        return 0;
    }
}

