/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization.avro;

import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.avro.message.SchemaStore;
import org.axonframework.serialization.avro.AvroConverterStrategy;
import org.axonframework.serialization.avro.AvroConverterStrategyConfiguration;
import org.axonframework.serialization.avro.DefaultSchemaIncompatibilityChecker;
import org.axonframework.serialization.avro.SchemaIncompatibilityChecker;

public record AvroConverterConfiguration(@Nonnull List<AvroConverterStrategy> strategies, boolean includeDefaultAvroConverterStrategies, @Nonnull SchemaStore schemaStore, @Nonnull SchemaIncompatibilityChecker schemaIncompatibilityChecker, @Nonnull AvroConverterStrategyConfiguration avroConverterStrategyConfiguration) {
    public AvroConverterConfiguration {
        Objects.requireNonNull(strategies, "Avro converter strategies cannot be null");
        Objects.requireNonNull(schemaStore, "Schema store cannot be null");
        Objects.requireNonNull(schemaIncompatibilityChecker, "Schema incompatibility checker cannot be null");
        Objects.requireNonNull(avroConverterStrategyConfiguration, "Avro converter strategy configuration cannot be null");
        if (!includeDefaultAvroConverterStrategies && strategies.isEmpty()) {
            throw new IllegalArgumentException("At least one Avro converter strategy is required and no default strategies will be used");
        }
    }

    public AvroConverterConfiguration(@Nonnull SchemaStore schemaStore) {
        this(new ArrayList<AvroConverterStrategy>(), true, schemaStore, new DefaultSchemaIncompatibilityChecker(), AvroConverterStrategyConfiguration.DEFAULT);
    }

    public AvroConverterConfiguration addConverterStrategy(@Nonnull AvroConverterStrategy strategy) {
        ArrayList<AvroConverterStrategy> strategies = new ArrayList<AvroConverterStrategy>(this.strategies);
        strategies.add(Objects.requireNonNull(strategy, "Avro converter strategy cannot be null"));
        return new AvroConverterConfiguration(strategies, this.includeDefaultAvroConverterStrategies, this.schemaStore, this.schemaIncompatibilityChecker, this.avroConverterStrategyConfiguration);
    }

    public AvroConverterConfiguration includeDefaultAvroConverterStrategies(boolean includeDefaultAvroConverterStrategies) {
        return new AvroConverterConfiguration(this.strategies, includeDefaultAvroConverterStrategies, this.schemaStore, this.schemaIncompatibilityChecker, this.avroConverterStrategyConfiguration);
    }

    public AvroConverterConfiguration schemaIncompatibilityChecker(@Nonnull SchemaIncompatibilityChecker schemaIncompatibilityChecker) {
        return new AvroConverterConfiguration(this.strategies, this.includeDefaultAvroConverterStrategies, this.schemaStore, Objects.requireNonNull(schemaIncompatibilityChecker, "Schema incompatibility checker cannot be null"), this.avroConverterStrategyConfiguration);
    }

    public AvroConverterConfiguration includeSchemasInStackTraces(boolean includeSchemasInStackTraces) {
        return new AvroConverterConfiguration(this.strategies, this.includeDefaultAvroConverterStrategies, this.schemaStore, this.schemaIncompatibilityChecker, new AvroConverterStrategyConfiguration(this.avroConverterStrategyConfiguration.performAvroCompatibilityCheck(), includeSchemasInStackTraces));
    }

    public AvroConverterConfiguration performAvroCompatibilityCheck(boolean performAvroCompatibilityCheck) {
        return new AvroConverterConfiguration(this.strategies, this.includeDefaultAvroConverterStrategies, this.schemaStore, this.schemaIncompatibilityChecker, new AvroConverterStrategyConfiguration(performAvroCompatibilityCheck, this.avroConverterStrategyConfiguration.includeSchemasInStackTraces()));
    }
}

