/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.monitoring;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.axonframework.common.Assert;
import org.axonframework.messaging.Message;
import org.axonframework.monitoring.MessageMonitor;

public class MultiMessageMonitor<T extends Message>
implements MessageMonitor<T> {
    private final List<MessageMonitor<? super T>> messageMonitors;

    @SafeVarargs
    public MultiMessageMonitor(MessageMonitor<? super T> ... messageMonitors) {
        this(Arrays.asList(messageMonitors));
    }

    public MultiMessageMonitor(List<MessageMonitor<? super T>> messageMonitors) {
        Assert.notNull(messageMonitors, () -> "MessageMonitor list may not be null");
        this.messageMonitors = Collections.unmodifiableList(messageMonitors);
    }

    @Override
    public MessageMonitor.MonitorCallback onMessageIngested(@Nonnull T message) {
        final List<MessageMonitor.MonitorCallback> monitorCallbacks = this.messageMonitors.stream().map(messageMonitor -> messageMonitor.onMessageIngested(message)).toList();
        return new MessageMonitor.MonitorCallback(){

            @Override
            public void reportSuccess() {
                monitorCallbacks.forEach(MessageMonitor.MonitorCallback::reportSuccess);
            }

            @Override
            public void reportFailure(Throwable cause) {
                monitorCallbacks.forEach(resultCallback -> resultCallback.reportFailure(cause));
            }

            @Override
            public void reportIgnored() {
                monitorCallbacks.forEach(MessageMonitor.MonitorCallback::reportIgnored);
            }
        };
    }

    public List<MessageMonitor<? super T>> messageMonitors() {
        return this.messageMonitors;
    }
}

