/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.messaging.unitofwork.ProcessingLifecycle;

public class ResourceOverridingProcessingContext<R>
implements ProcessingContext {
    private final ProcessingContext delegate;
    private final Context.ResourceKey<R> key;
    private final AtomicReference<R> resource;

    public ResourceOverridingProcessingContext(@Nonnull ProcessingContext delegate, @Nonnull Context.ResourceKey<R> key, R resource) {
        this.delegate = delegate;
        this.key = key;
        this.resource = new AtomicReference<R>(resource);
    }

    @Override
    public boolean isStarted() {
        return this.delegate.isStarted();
    }

    @Override
    public boolean isError() {
        return this.delegate.isError();
    }

    @Override
    public boolean isCommitted() {
        return this.delegate.isCommitted();
    }

    @Override
    public boolean isCompleted() {
        return this.delegate.isCompleted();
    }

    @Override
    public ProcessingLifecycle on(ProcessingLifecycle.Phase phase, Function<ProcessingContext, CompletableFuture<?>> action) {
        return this.delegate.on(phase, action);
    }

    @Override
    public ProcessingLifecycle runOn(ProcessingLifecycle.Phase phase, Consumer<ProcessingContext> action) {
        return this.delegate.runOn(phase, action);
    }

    @Override
    public ProcessingLifecycle onPreInvocation(Function<ProcessingContext, CompletableFuture<?>> action) {
        return this.delegate.onPreInvocation(action);
    }

    @Override
    public ProcessingLifecycle runOnPreInvocation(Consumer<ProcessingContext> action) {
        return this.delegate.runOnPreInvocation(action);
    }

    @Override
    public ProcessingLifecycle onInvocation(Function<ProcessingContext, CompletableFuture<?>> action) {
        return this.delegate.onInvocation(action);
    }

    @Override
    public ProcessingLifecycle runOnInvocation(Consumer<ProcessingContext> action) {
        return this.delegate.runOnInvocation(action);
    }

    @Override
    public ProcessingLifecycle onPostInvocation(Function<ProcessingContext, CompletableFuture<?>> action) {
        return this.delegate.onPostInvocation(action);
    }

    @Override
    public ProcessingLifecycle runOnPostInvocation(Consumer<ProcessingContext> action) {
        return this.delegate.runOnPostInvocation(action);
    }

    @Override
    public ProcessingLifecycle onPrepareCommit(Function<ProcessingContext, CompletableFuture<?>> action) {
        return this.delegate.onPrepareCommit(action);
    }

    @Override
    public ProcessingLifecycle runOnPrepareCommit(Consumer<ProcessingContext> action) {
        return this.delegate.runOnPrepareCommit(action);
    }

    @Override
    public ProcessingLifecycle onCommit(Function<ProcessingContext, CompletableFuture<?>> action) {
        return this.delegate.onCommit(action);
    }

    @Override
    public ProcessingLifecycle runOnCommit(Consumer<ProcessingContext> action) {
        return this.delegate.runOnCommit(action);
    }

    @Override
    public ProcessingLifecycle onAfterCommit(Function<ProcessingContext, CompletableFuture<?>> action) {
        return this.delegate.onAfterCommit(action);
    }

    @Override
    public ProcessingLifecycle runOnAfterCommit(Consumer<ProcessingContext> action) {
        return this.delegate.runOnAfterCommit(action);
    }

    @Override
    public ProcessingLifecycle onError(ProcessingLifecycle.ErrorHandler action) {
        return this.delegate.onError(action);
    }

    @Override
    public ProcessingLifecycle whenComplete(Consumer<ProcessingContext> action) {
        return this.delegate.whenComplete(action);
    }

    @Override
    public ProcessingLifecycle doFinally(Consumer<ProcessingContext> action) {
        return this.delegate.doFinally(action);
    }

    @Override
    public boolean containsResource(@Nonnull Context.ResourceKey<?> key) {
        return this.key.equals(key) || this.delegate.containsResource(key);
    }

    @Override
    public <T> T getResource(@Nonnull Context.ResourceKey<T> key) {
        return (T)(this.key.equals(key) ? this.resource.get() : this.delegate.getResource(key));
    }

    @Override
    public Map<Context.ResourceKey<?>, Object> resources() {
        Map<Context.ResourceKey<?>, Object> allResources = this.delegate.resources();
        allResources.put(this.key, this.resource.get());
        return allResources;
    }

    @Override
    public <T> T putResource(@Nonnull Context.ResourceKey<T> key, @Nonnull T resource) {
        return (T)(this.key.equals(key) ? this.resource.getAndSet(resource) : this.delegate.putResource(key, resource));
    }

    @Override
    public <T> T updateResource(@Nonnull Context.ResourceKey<T> key, @Nonnull UnaryOperator<T> resourceUpdater) {
        return (T)(this.key.equals(key) ? this.resource.updateAndGet(resourceUpdater) : this.delegate.updateResource(key, resourceUpdater));
    }

    @Override
    public <T> T computeResourceIfAbsent(@Nonnull Context.ResourceKey<T> key, @Nonnull Supplier<T> resourceSupplier) {
        if (this.key.equals(key)) {
            return (T)this.resource.updateAndGet(current -> current == null ? resourceSupplier.get() : current);
        }
        return this.delegate.computeResourceIfAbsent(key, resourceSupplier);
    }

    @Override
    public <T> T putResourceIfAbsent(@Nonnull Context.ResourceKey<T> key, @Nonnull T resource) {
        if (this.key.equals(key)) {
            return (T)this.resource.getAndUpdate(current -> current == null ? resource : current);
        }
        return this.delegate.putResourceIfAbsent(key, resource);
    }

    @Override
    public <T> T removeResource(@Nonnull Context.ResourceKey<T> key) {
        if (!this.key.equals(key)) {
            return this.delegate.removeResource(key);
        }
        return this.resource.getAndSet(null);
    }

    @Override
    public <T> boolean removeResource(@Nonnull Context.ResourceKey<T> key, @Nonnull T expectedResource) {
        return this.key.equals(key) ? this.resource.compareAndSet(expectedResource, null) : this.delegate.removeResource(key, expectedResource);
    }

    @Override
    @Nonnull
    public <C> C component(@Nonnull Class<C> type) {
        return this.delegate.component(type);
    }

    @Override
    @Nonnull
    public <C> C component(@Nonnull Class<C> type, @Nullable String name) {
        return this.delegate.component(type, name);
    }
}

