/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.interceptors;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.common.annotations.Internal;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageDispatchInterceptor;
import org.axonframework.messaging.MessageDispatchInterceptorChain;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageHandlerInterceptorChain;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.correlation.CorrelationDataProvider;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Internal
public class CorrelationDataInterceptor<M extends Message>
implements MessageDispatchInterceptor<M>,
MessageHandlerInterceptor<M> {
    public static final Context.ResourceKey<Map<String, String>> CORRELATION_DATA = Context.ResourceKey.withLabel("CorrelationData");
    private final List<CorrelationDataProvider> correlationDataProviders;

    public CorrelationDataInterceptor(CorrelationDataProvider ... correlationDataProviders) {
        this(Arrays.asList(correlationDataProviders));
    }

    public CorrelationDataInterceptor(@Nonnull Collection<CorrelationDataProvider> correlationDataProviders) {
        this.correlationDataProviders = new ArrayList<CorrelationDataProvider>(correlationDataProviders);
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnDispatch(@Nonnull M message, @Nullable ProcessingContext context, @Nonnull MessageDispatchInterceptorChain<M> chain) {
        return context == null || !context.containsResource(CORRELATION_DATA) ? chain.proceed((Message)message, context) : chain.proceed(message.andMetadata(context.getResource(CORRELATION_DATA)), context);
    }

    @Override
    @Nonnull
    public MessageStream<?> interceptOnHandle(@Nonnull M message, @Nonnull ProcessingContext context, @Nonnull MessageHandlerInterceptorChain<M> chain) {
        ConcurrentHashMap correlationData = new ConcurrentHashMap();
        this.correlationDataProviders.forEach(provider -> correlationData.putAll(provider.correlationDataFor((Message)message)));
        return chain.proceed(message, (ProcessingContext)context.withResource((Context.ResourceKey)CORRELATION_DATA, correlationData));
    }
}

