/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.annotations;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.axonframework.common.Priority;
import org.axonframework.messaging.LegacyResources;
import org.axonframework.messaging.annotations.AbstractAnnotatedParameterResolverFactory;
import org.axonframework.messaging.annotations.AggregateType;
import org.axonframework.messaging.annotations.ParameterResolver;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Priority(value=0x3FFFFFFF)
public final class AggregateTypeParameterResolverFactory
extends AbstractAnnotatedParameterResolverFactory<AggregateType, String> {
    private final ParameterResolver<String> resolver = new AggregateTypeParameterResolver();

    public AggregateTypeParameterResolverFactory() {
        super(AggregateType.class, String.class);
    }

    @Override
    protected ParameterResolver<String> getResolver() {
        return this.resolver;
    }

    static class AggregateTypeParameterResolver
    implements ParameterResolver<String> {
        AggregateTypeParameterResolver() {
        }

        @Override
        @Nullable
        public String resolveParameterValue(@Nonnull ProcessingContext context) {
            String aggregateType = context.getResource(LegacyResources.AGGREGATE_TYPE_KEY);
            if (aggregateType != null) {
                return aggregateType;
            }
            return null;
        }

        @Override
        public boolean matches(@Nonnull ProcessingContext context) {
            return context.containsResource(LegacyResources.AGGREGATE_TYPE_KEY);
        }
    }
}

