/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging;

import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.messaging.DelegatingMessageStream;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;

class TruncateFirstMessageStream<M extends Message>
extends DelegatingMessageStream<M, M>
implements MessageStream.Single<M> {
    private final AtomicBoolean consumed = new AtomicBoolean(false);

    public TruncateFirstMessageStream(@Nonnull MessageStream<M> delegate) {
        super(delegate);
    }

    @Override
    public Optional<MessageStream.Entry<M>> next() {
        Optional<MessageStream.Entry<M>> next = this.delegate().next();
        if (next.isPresent() && this.consumed.compareAndSet(false, true)) {
            this.close();
            return next;
        }
        return Optional.empty();
    }

    @Override
    public void setCallback(@Nonnull Runnable callback) {
        super.setCallback(() -> {
            if (!this.consumed.get()) {
                callback.run();
            }
        });
    }

    @Override
    public Optional<Throwable> error() {
        return this.consumed.get() ? Optional.empty() : super.error();
    }

    @Override
    public boolean isCompleted() {
        return this.consumed.get() || super.isCompleted();
    }

    @Override
    public boolean hasNextAvailable() {
        return !this.consumed.get() && super.hasNextAvailable();
    }

    @Override
    public Optional<MessageStream.Entry<M>> peek() {
        if (!this.consumed.get()) {
            return this.delegate().peek();
        }
        return Optional.empty();
    }
}

