/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiFunction;
import org.axonframework.common.Registration;
import org.axonframework.common.annotations.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class EventSubscribers
implements DescribableComponent {
    private static final Logger logger = LoggerFactory.getLogger(EventSubscribers.class);
    private final Set<BiFunction<List<? extends EventMessage>, ProcessingContext, CompletableFuture<?>>> subscribers = new CopyOnWriteArraySet();

    EventSubscribers() {
    }

    public Registration subscribe(@Nonnull BiFunction<List<? extends EventMessage>, ProcessingContext, CompletableFuture<?>> eventsBatchConsumer) {
        if (this.subscribers.add(eventsBatchConsumer)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Event subscriber [{}] subscribed successfully", eventsBatchConsumer);
            }
        } else {
            logger.info("Event subscriber [{}] not added. It was already subscribed", eventsBatchConsumer);
        }
        return () -> {
            if (this.subscribers.remove(eventsBatchConsumer)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Event subscriber {} unsubscribed successfully", (Object)eventsBatchConsumer);
                }
                return true;
            }
            logger.info("Event subscriber {} not removed. It was already unsubscribed", (Object)eventsBatchConsumer);
            return false;
        };
    }

    public CompletableFuture<Void> notifySubscribers(@Nonnull List<? extends EventMessage> events, @Nullable ProcessingContext context) {
        CompletableFuture[] consumeFutures = (CompletableFuture[])this.subscribers.stream().map(subscriber -> (CompletableFuture)subscriber.apply(events, context)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(consumeFutures);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("subscribers", this.subscribers);
    }
}

