/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.infra;

import jakarta.annotation.Nonnull;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.common.infra.ComponentDescriptorException;
import org.axonframework.common.infra.DescribableComponent;
import org.axonframework.configuration.Component;

public class FilesystemStyleComponentDescriptor
implements ComponentDescriptor {
    private static final String ROOT_PATH = "/";
    private static final String PATH_SEPARATOR = "/";
    private final Map<Object, String> componentPaths;
    private final Map<String, Object> processedComponents;
    private final String currentPath;

    public FilesystemStyleComponentDescriptor() {
        this(new IdentityHashMap<Object, String>(), "/");
    }

    private FilesystemStyleComponentDescriptor(Map<Object, String> componentPaths, String currentPath) {
        this.componentPaths = componentPaths;
        this.currentPath = currentPath;
        this.processedComponents = new LinkedHashMap<String, Object>();
    }

    @Override
    public void describeProperty(@Nonnull String name, Object object) {
        if (object instanceof DescribableComponent) {
            DescribableComponent component = (DescribableComponent)object;
            this.describeComponent(name, component);
        } else {
            this.processedComponents.put(name, object);
        }
    }

    private void describeComponent(String name, DescribableComponent component) {
        boolean componentSeenAlready = this.componentPaths.containsKey(component);
        if (componentSeenAlready) {
            String existingPath = this.componentPaths.get(component);
            this.processedComponents.put(name, new SymbolicLink(existingPath));
            return;
        }
        String componentPath = this.currentPathChild(name);
        this.componentPaths.put(component, componentPath);
        this.processedComponents.put(name, this.componentDescriptor(component, componentPath));
    }

    private String currentPathChild(String name) {
        return this.currentPath.equals("/") ? this.currentPath + name : this.currentPath + "/" + name;
    }

    @Override
    public void describeProperty(@Nonnull String name, Collection<?> collection) {
        if (collection == null) {
            this.processedComponents.put(name, null);
            return;
        }
        ArrayList items = new ArrayList();
        int index = 0;
        for (Object item : collection) {
            Object object;
            if (item instanceof DescribableComponent) {
                DescribableComponent component = (DescribableComponent)item;
                object = this.describeComponentInCollection(name, index, component);
            } else {
                object = item;
            }
            Object property = object;
            items.add(property);
            ++index;
        }
        this.processedComponents.put(name, items);
    }

    private Object describeComponentInCollection(String name, int index, DescribableComponent component) {
        boolean componentSeenAlready = this.componentPaths.containsKey(component);
        if (componentSeenAlready) {
            String existingPath = this.componentPaths.get(component);
            return new SymbolicLink(existingPath);
        }
        String itemName = name + "[" + index + "]";
        String itemPath = this.currentPathChild(itemName);
        this.componentPaths.put(component, itemPath);
        return this.componentDescriptor(component, itemPath);
    }

    @Override
    public void describeProperty(@Nonnull String name, Map<?, ?> map) {
        if (map == null) {
            this.processedComponents.put(name, null);
            return;
        }
        LinkedHashMap mappedItems = new LinkedHashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object object;
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof DescribableComponent) {
                DescribableComponent component = (DescribableComponent)value;
                object = this.describeComponentInMap(name, key, component);
            } else {
                object = value;
            }
            Object property = object;
            mappedItems.put(key, property);
        }
        this.processedComponents.put(name, mappedItems);
    }

    private Object describeComponentInMap(String name, String key, DescribableComponent component) {
        boolean componentSeenAlready = this.componentPaths.containsKey(component);
        if (componentSeenAlready) {
            String existingPath = this.componentPaths.get(component);
            return new SymbolicLink(existingPath);
        }
        String itemName = name + "[" + key + "]";
        String itemPath = this.currentPathChild(itemName);
        this.componentPaths.put(component, itemPath);
        return this.componentDescriptor(component, itemPath);
    }

    private ComponentDescriptor componentDescriptor(DescribableComponent component, String itemPath) {
        FilesystemStyleComponentDescriptor descriptor = new FilesystemStyleComponentDescriptor(this.componentPaths, itemPath);
        String type = component instanceof Component ? ((Component)component).identifier().typeAsClass().getName() : component.getClass().getName();
        descriptor.describeProperty("_ref", System.identityHashCode(component));
        descriptor.describeProperty("_type", type);
        component.describeTo(descriptor);
        return descriptor;
    }

    @Override
    public void describeProperty(@Nonnull String name, String value) {
        this.processedComponents.put(name, value);
    }

    @Override
    public void describeProperty(@Nonnull String name, Long value) {
        this.processedComponents.put(name, value);
    }

    @Override
    public void describeProperty(@Nonnull String name, Boolean value) {
        this.processedComponents.put(name, value);
    }

    @Override
    public String describe() {
        try {
            return new TreeRenderer().render(this.processedComponents);
        }
        catch (Exception e) {
            throw new ComponentDescriptorException("Error generating Filesystem style description", e);
        }
    }

    private record SymbolicLink(String targetPath) {
        private static final String SYMLINK_INDICATOR = " -> ";

        @Override
        public String toString() {
            return SYMLINK_INDICATOR + this.targetPath;
        }
    }

    private static class TreeRenderer {
        private static final String CORNER = "\u2514\u2500\u2500 ";
        private static final String TEE = "\u251c\u2500\u2500 ";
        private static final String VERTICAL = "\u2502   ";
        private static final String SPACE = "    ";
        private final StringBuilder result = new StringBuilder();

        private TreeRenderer() {
        }

        String render(Map<String, Object> properties) {
            this.result.append("/").append("\n");
            RenderContext context = new RenderContext("", "");
            this.render(properties, context);
            return this.result.toString();
        }

        private void render(Map<String, Object> properties, RenderContext context) {
            ArrayList<Map.Entry<String, Object>> entries = new ArrayList<Map.Entry<String, Object>>(properties.entrySet());
            for (int i = 0; i < entries.size(); ++i) {
                Map.Entry<String, Object> entry = entries.get(i);
                String name = entry.getKey();
                Object value = entry.getValue();
                boolean isLast = i == entries.size() - 1;
                this.renderProperty(name, value, context, isLast);
            }
        }

        private void renderProperty(String name, Object value, RenderContext context, boolean isLastInCollection) {
            Object object = value;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FilesystemStyleComponentDescriptor.class, List.class, Map.class, SymbolicLink.class}, (Object)object, n)) {
                case 0: {
                    FilesystemStyleComponentDescriptor descriptor = (FilesystemStyleComponentDescriptor)object;
                    this.renderComponentDirectory(name, descriptor, context, isLastInCollection);
                    break;
                }
                case 1: {
                    List list = (List)object;
                    this.renderList(name, list, context, isLastInCollection);
                    break;
                }
                case 2: {
                    Map map = (Map)object;
                    this.renderMap(name, map, context, isLastInCollection);
                    break;
                }
                case 3: {
                    SymbolicLink link = (SymbolicLink)object;
                    this.renderSymlink(name, link, context, isLastInCollection);
                    break;
                }
                default: {
                    this.renderSimpleValue(name, value, context, isLastInCollection);
                }
            }
        }

        private void renderComponentDirectory(String name, FilesystemStyleComponentDescriptor descriptor, RenderContext context, boolean isLastInCollection) {
            this.result.append(context.indent).append(this.connectorForProperty(isLastInCollection)).append(name).append("/\n");
            RenderContext childContext = context.indented(name, isLastInCollection);
            this.render(descriptor.processedComponents, childContext);
        }

        private void renderList(String name, List<?> list, RenderContext context, boolean isLastInCollection) {
            this.result.append(context.indent).append(this.connectorForProperty(isLastInCollection)).append(name).append("/\n");
            RenderContext listContext = context.indented(name, isLastInCollection);
            for (int j = 0; j < list.size(); ++j) {
                Object item = list.get(j);
                boolean isLastItem = j == list.size() - 1;
                String key = "[" + j + "]";
                this.renderMapOrListEntry(key, item, listContext, isLastItem);
            }
        }

        private String connectorForProperty(boolean isLastInCollection) {
            return isLastInCollection ? CORNER : TEE;
        }

        private void renderMapOrListEntry(String key, Object item, RenderContext listContext, boolean isLastInCollection) {
            this.result.append(listContext.indent).append(this.connectorForProperty(isLastInCollection)).append(key);
            if (item instanceof FilesystemStyleComponentDescriptor) {
                FilesystemStyleComponentDescriptor itemDescriptor = (FilesystemStyleComponentDescriptor)item;
                this.result.append("/\n");
                RenderContext itemContext = listContext.indented(key, isLastInCollection);
                this.render(itemDescriptor.processedComponents, itemContext);
            } else if (item instanceof SymbolicLink) {
                SymbolicLink link = (SymbolicLink)item;
                this.result.append(link).append("\n");
            } else {
                this.result.append(": ").append(this.valueOrNull(item)).append("\n");
            }
        }

        private void renderMap(String name, Map<?, ?> map, RenderContext context, boolean isLastInCollection) {
            this.result.append(context.indent).append(this.connectorForProperty(isLastInCollection)).append(name).append("/\n");
            RenderContext mapContext = context.indented(name, isLastInCollection);
            ArrayList mapEntries = new ArrayList(map.entrySet());
            mapEntries.sort(Comparator.comparing(entry -> entry.getKey().toString()));
            for (int j = 0; j < mapEntries.size(); ++j) {
                Map.Entry<?, ?> mapEntry = mapEntries.get(j);
                String key = mapEntry.getKey().toString();
                Object mapValue = mapEntry.getValue();
                boolean isLastMapEntry = j == mapEntries.size() - 1;
                this.renderMapOrListEntry(key, mapValue, mapContext, isLastMapEntry);
            }
        }

        private void renderSymlink(String name, SymbolicLink link, RenderContext context, boolean isLastInCollection) {
            this.result.append(context.indent).append(this.connectorForProperty(isLastInCollection)).append(name).append(link).append("\n");
        }

        private void renderSimpleValue(String name, Object value, RenderContext context, boolean isLastInCollection) {
            this.result.append(context.indent).append(this.connectorForProperty(isLastInCollection)).append(name).append(": ").append(this.valueOrNull(value)).append("\n");
        }

        private String valueOrNull(Object value) {
            return value == null ? "null" : value.toString();
        }

        private record RenderContext(String path, String indent) {
            RenderContext indented(String name, boolean isLast) {
                String childPath = this.path.isEmpty() ? name : this.path + "/" + name;
                String childIndent = this.indent + (isLast ? TreeRenderer.SPACE : TreeRenderer.VERTICAL);
                return new RenderContext(childPath, childIndent);
            }
        }
    }
}

