/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common.caching;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.axonframework.common.Registration;

public interface Cache {
    public <K, V> V get(K var1);

    public void put(Object var1, Object var2);

    public boolean putIfAbsent(Object var1, Object var2);

    default public <T> T computeIfAbsent(Object key, Supplier<T> valueSupplier) {
        Object currentValue = this.get(key);
        if (currentValue != null) {
            return (T)currentValue;
        }
        T newValue = valueSupplier.get();
        if (newValue == null) {
            throw new IllegalArgumentException("Value Supplier of Cache produced a null value for key [" + String.valueOf(key) + "]!");
        }
        this.put(key, newValue);
        return newValue;
    }

    public boolean remove(Object var1);

    default public void removeAll() {
        throw new UnsupportedOperationException("Cache#removeAll is currently unsupported by this version");
    }

    public boolean containsKey(Object var1);

    public Registration registerCacheEntryListener(EntryListener var1);

    default public <V> void computeIfPresent(Object key, UnaryOperator<V> update) {
        throw new UnsupportedOperationException("Cache#computeIfPresent is currently unsupported by this version");
    }

    public static class EntryListenerAdapter
    implements EntryListener {
        @Override
        public void onEntryExpired(Object key) {
        }

        @Override
        public void onEntryRemoved(Object key) {
        }

        @Override
        public void onEntryUpdated(Object key, Object value) {
        }

        @Override
        public void onEntryCreated(Object key, Object value) {
        }

        @Override
        public void onEntryRead(Object key, Object value) {
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    public static interface EntryListener {
        public void onEntryExpired(Object var1);

        public void onEntryRemoved(Object var1);

        public void onEntryUpdated(Object var1, Object var2);

        public void onEntryCreated(Object var1, Object var2);

        public void onEntryRead(Object var1, Object var2);

        public Object clone() throws CloneNotSupportedException;
    }
}

