/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.common;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ObjectUtils {
    private ObjectUtils() {
    }

    public static <T> T getOrDefault(T instance, Supplier<T> defaultProvider) {
        if (instance == null) {
            return defaultProvider.get();
        }
        return instance;
    }

    public static <T> T getOrDefault(T instance, T defaultValue) {
        if (instance == null) {
            return defaultValue;
        }
        return instance;
    }

    public static <T extends CharSequence> T getNonEmptyOrDefault(T instance, T defaultValue) {
        if (instance == null || instance.length() == 0) {
            return defaultValue;
        }
        return instance;
    }

    public static <I, T> T getOrDefault(I instance, Function<I, T> valueProvider, T defaultValue) {
        return instance != null ? valueProvider.apply(instance) : defaultValue;
    }

    public static <T> Class<T> nullSafeTypeOf(T instance) {
        if (instance == null) {
            return Void.class;
        }
        return instance.getClass();
    }

    public static long getRemainingOfDeadline(long deadline) {
        long leftTimeout = deadline - System.currentTimeMillis();
        leftTimeout = leftTimeout < 0L ? 0L : leftTimeout;
        return leftTimeout;
    }

    public static <T> Supplier<T> sameInstanceSupplier(Supplier<T> supplier) {
        AtomicReference instanceRef = new AtomicReference();
        return () -> instanceRef.updateAndGet(arg_0 -> ObjectUtils.lambda$sameInstanceSupplier$0((Supplier)supplier, arg_0));
    }

    private static /* synthetic */ Object lambda$sameInstanceSupplier$0(Supplier supplier, Object current) {
        return ObjectUtils.getOrDefault(current, supplier);
    }
}

