/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.commandhandling.gateway;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.axonframework.commandhandling.gateway.CommandDispatcher;
import org.axonframework.commandhandling.gateway.CommandGateway;
import org.axonframework.commandhandling.gateway.CommandResult;
import org.axonframework.common.annotations.Internal;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.unitofwork.ProcessingContext;

@Internal
public class ContextAwareCommandDispatcher
implements CommandDispatcher {
    private final CommandGateway commandGateway;
    private final ProcessingContext context;

    ContextAwareCommandDispatcher(@Nonnull CommandGateway commandGateway, @Nonnull ProcessingContext context) {
        this.commandGateway = Objects.requireNonNull(commandGateway, "The Command Gateway must not be null.");
        this.context = Objects.requireNonNull(context, "The Processing Context must not be null.");
    }

    @Override
    public CommandResult send(@Nonnull Object command) {
        return this.commandGateway.send(command, this.context);
    }

    @Override
    public CommandResult send(@Nonnull Object command, @Nonnull Metadata metadata) {
        return this.commandGateway.send(command, metadata, this.context);
    }

    @Override
    public void describeTo(@Nonnull ComponentDescriptor descriptor) {
        descriptor.describeProperty("processingContext", this.context);
        descriptor.describeProperty("commandGateway", this.commandGateway);
    }
}

