/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.updates.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import org.axonframework.common.annotations.Internal;
import org.axonframework.updates.configuration.DefaultUsagePropertyProvider;
import org.axonframework.updates.configuration.UsagePropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class PropertyFileUsagePropertyProvider
implements UsagePropertyProvider {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFileUsagePropertyProvider.class);
    private static final String AXONIQ_PROPERTIES_PATH = "/.axoniq/update-checker.properties";
    private Boolean optOut;
    private String telemetryEndpoint;
    private boolean loaded = false;

    @Override
    public Boolean getDisabled() {
        this.ensureLoaded();
        return this.optOut;
    }

    @Override
    public String getUrl() {
        this.ensureLoaded();
        return this.telemetryEndpoint;
    }

    private void ensureLoaded() {
        if (!this.loaded) {
            this.load();
            this.loaded = true;
        }
    }

    private void load() {
        try {
            File installationIdFile = this.getFile();
            if (installationIdFile == null) {
                logger.debug("Could not determine user home directory. Skipping property provider from file.");
                return;
            }
            Properties properties = new Properties();
            if (!installationIdFile.exists()) {
                this.createDefaultFile();
            }
            properties.load(Files.newInputStream(installationIdFile.toPath(), new OpenOption[0]));
            this.telemetryEndpoint = properties.getProperty("telemetry_url");
            this.optOut = Boolean.valueOf(properties.getProperty("disabled"));
        }
        catch (Exception e) {
            logger.debug("Failed to load AxonIQ properties from file: {}. Skipping property provider from file.", (Object)this.getFile().getAbsolutePath(), (Object)e);
        }
    }

    @Override
    public int priority() {
        return 0;
    }

    private void createDefaultFile() throws IOException {
        File file = this.getFile();
        if (file == null) {
            logger.debug("Could not determine user home directory. Skipping creation of default properties file.");
            return;
        }
        logger.info("Creating default AxonIQ Data Collection properties file at: {}", (Object)file.getAbsolutePath());
        Properties properties = new Properties();
        properties.setProperty("telemetry_url", DefaultUsagePropertyProvider.INSTANCE.getUrl());
        properties.setProperty("opted_out", String.valueOf(DefaultUsagePropertyProvider.INSTANCE.getDisabled()));
        File parentDir = file.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Failed to create parent directory: " + parentDir.getAbsolutePath());
        }
        properties.store(Files.newOutputStream(file.toPath(), new OpenOption[0]), "AxonIQ Anonymous Usage Reporting");
    }

    private File getFile() {
        String pwdDir = System.getProperty("user.home");
        if (pwdDir == null) {
            return null;
        }
        String installationIdFilePath = pwdDir + AXONIQ_PROPERTIES_PATH;
        return new File(installationIdFilePath);
    }
}

