/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.Function;
import org.axonframework.messaging.Message;
import org.axonframework.queryhandling.SubscriptionQueryResponse;
import org.axonframework.queryhandling.SubscriptionQueryResponseMessages;
import reactor.core.publisher.Flux;

public class GenericSubscriptionQueryResponse<I, U>
implements SubscriptionQueryResponse<I, U> {
    private final SubscriptionQueryResponseMessages response;
    private final Function<Message, I> initialConverter;
    private final Function<Message, U> updateConverter;

    public GenericSubscriptionQueryResponse(@Nonnull SubscriptionQueryResponseMessages response, @Nonnull Function<Message, I> initialConverter, @Nonnull Function<Message, U> updateConverter) {
        this.response = Objects.requireNonNull(response, "The response stream must not be null.");
        this.initialConverter = Objects.requireNonNull(initialConverter, "The initial converter must not be null.");
        this.updateConverter = Objects.requireNonNull(updateConverter, "The update converter must not be null.");
    }

    @Override
    @Nonnull
    public Flux<I> initialResult() {
        return this.response.initialResult().mapNotNull(response -> Objects.isNull(response.payload()) ? null : this.initialConverter.apply((Message)response));
    }

    @Override
    @Nonnull
    public Flux<U> updates() {
        return this.response.updates().mapNotNull(response -> Objects.isNull(response.payload()) ? null : this.updateConverter.apply((Message)response));
    }

    @Override
    public void close() {
        this.response.close();
    }
}

