/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.queryhandling;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Type;
import java.util.Map;
import org.axonframework.common.ObjectUtils;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageType;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.responsetypes.PublisherResponseType;
import org.axonframework.messaging.responsetypes.ResponseType;
import org.axonframework.queryhandling.GenericQueryMessage;
import org.axonframework.queryhandling.StreamingQueryMessage;
import org.axonframework.serialization.Converter;
import org.reactivestreams.Publisher;

public class GenericStreamingQueryMessage
extends GenericQueryMessage
implements StreamingQueryMessage {
    public <P> GenericStreamingQueryMessage(@Nonnull MessageType type, @Nullable Object payload, @Nonnull Class<P> responseType) {
        this((Message)new GenericMessage(type, payload, Metadata.emptyInstance()), (ResponseType<Publisher<P>>)new PublisherResponseType<P>(responseType));
    }

    public <P> GenericStreamingQueryMessage(@Nonnull Message delegate, @Nonnull Class<P> responseType) {
        this(delegate, (ResponseType<Publisher<P>>)new PublisherResponseType<P>(responseType));
    }

    private <P> GenericStreamingQueryMessage(@Nonnull Message delegate, @Nonnull ResponseType<Publisher<P>> responseType) {
        super(delegate, responseType);
    }

    @Override
    @Nonnull
    public ResponseType<Publisher<?>> responseType() {
        return super.responseType();
    }

    @Override
    @Nonnull
    public StreamingQueryMessage withMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericStreamingQueryMessage(this.delegate().withMetadata(metadata), this.internalResponseType());
    }

    @Override
    @Nonnull
    public StreamingQueryMessage andMetadata(@Nonnull Map<String, String> metadata) {
        return new GenericStreamingQueryMessage(this.delegate().andMetadata(metadata), this.internalResponseType());
    }

    @Override
    @Nonnull
    public StreamingQueryMessage withConvertedPayload(@Nonnull Type type, @Nonnull Converter converter) {
        Object convertedPayload = this.payloadAs(type, converter);
        if (ObjectUtils.nullSafeTypeOf(convertedPayload).isAssignableFrom(this.payloadType())) {
            return (StreamingQueryMessage)super.withConvertedPayload(type, converter);
        }
        Message delegate = this.delegate();
        GenericMessage converted = new GenericMessage(delegate.identifier(), delegate.type(), convertedPayload, delegate.metadata());
        return new GenericStreamingQueryMessage((Message)converted, this.internalResponseType());
    }

    @Override
    protected String describeType() {
        return "GenericStreamingQueryMessage";
    }

    @Nonnull
    private <P> ResponseType<Publisher<P>> internalResponseType() {
        return super.responseType();
    }
}

