/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.unitofwork;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.axonframework.messaging.Metadata;
import org.axonframework.messaging.unitofwork.LegacyUnitOfWork;

@Deprecated(since="5.0.0")
public abstract class CurrentUnitOfWork {
    private static final ThreadLocal<Deque<LegacyUnitOfWork<?>>> CURRENT = new ThreadLocal();

    public static boolean isStarted() {
        return CURRENT.get() != null && !CURRENT.get().isEmpty();
    }

    public static boolean ifStarted(Consumer<LegacyUnitOfWork<?>> consumer) {
        if (CurrentUnitOfWork.isStarted()) {
            consumer.accept(CurrentUnitOfWork.get());
            return true;
        }
        return false;
    }

    public static <T> Optional<T> map(Function<LegacyUnitOfWork<?>, T> function) {
        return CurrentUnitOfWork.isStarted() ? Optional.ofNullable(function.apply(CurrentUnitOfWork.get())) : Optional.empty();
    }

    public static LegacyUnitOfWork<?> get() {
        if (CurrentUnitOfWork.isEmpty()) {
            throw new IllegalStateException("No UnitOfWork is currently started for this thread.");
        }
        return CURRENT.get().peek();
    }

    private static boolean isEmpty() {
        Deque<LegacyUnitOfWork<?>> unitsOfWork = CURRENT.get();
        return unitsOfWork == null || unitsOfWork.isEmpty();
    }

    public static void commit() {
        CurrentUnitOfWork.get().commit();
    }

    public static void set(LegacyUnitOfWork<?> unitOfWork) {
        if (CURRENT.get() == null) {
            CURRENT.set(new LinkedList());
        }
        CURRENT.get().push(unitOfWork);
    }

    public static void clear(LegacyUnitOfWork<?> unitOfWork) {
        if (!CurrentUnitOfWork.isStarted()) {
            throw new IllegalStateException("Could not clear this UnitOfWork. There is no UnitOfWork active.");
        }
        if (CURRENT.get().peek() == unitOfWork) {
            CURRENT.get().pop();
            if (CURRENT.get().isEmpty()) {
                CURRENT.remove();
            }
        } else {
            throw new IllegalStateException("Could not clear this UnitOfWork. It is not the active one.");
        }
    }

    public static Metadata correlationData() {
        return CurrentUnitOfWork.map(LegacyUnitOfWork::getCorrelationData).orElse(Metadata.emptyInstance());
    }

    private CurrentUnitOfWork() {
    }
}

