/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.messaging.timeout;

import java.util.concurrent.ScheduledExecutorService;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.Context;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageHandlerInterceptor;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.timeout.AxonTaskJanitor;
import org.axonframework.messaging.timeout.AxonTimeLimitedTask;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.axonframework.queryhandling.QueryMessage;
import org.slf4j.Logger;

public class UnitOfWorkTimeoutInterceptorBuilder {
    private static final String TRANSACTION_TIME_LIMIT_RESOURCE_KEY = "_transactionTimeLimit";
    private static final Context.ResourceKey<AxonTimeLimitedTask> TRANSACTION_TIME_LIMIT_CONTEXT_RESOURCE_KEY = Context.ResourceKey.withLabel("_transactionTimeLimit");
    private final String componentName;
    private final int timeout;
    private final int warningThreshold;
    private final int warningInterval;
    private final ScheduledExecutorService executorService;
    private final Logger logger;

    public UnitOfWorkTimeoutInterceptorBuilder(String componentName, int timeout, int warningThreshold, int warningInterval) {
        this(componentName, timeout, warningThreshold, warningInterval, AxonTaskJanitor.INSTANCE, AxonTaskJanitor.LOGGER);
    }

    public UnitOfWorkTimeoutInterceptorBuilder(String componentName, int timeout, int warningThreshold, int warningInterval, ScheduledExecutorService executorService, Logger logger) {
        this.componentName = componentName;
        this.timeout = timeout;
        this.warningThreshold = warningThreshold;
        this.warningInterval = warningInterval;
        this.executorService = executorService;
        this.logger = logger;
    }

    public MessageHandlerInterceptor<CommandMessage> buildCommandInterceptor() {
        return this.build();
    }

    public MessageHandlerInterceptor<EventMessage> buildEventInterceptor() {
        return this.build();
    }

    public MessageHandlerInterceptor<QueryMessage> buildQueryInterceptor() {
        return this.build();
    }

    <T extends Message> MessageHandlerInterceptor<T> build() {
        return (message, context, interceptorChain) -> {
            this.initializeTimeoutIfNotInitialized(context);
            AxonTimeLimitedTask task = context.getResource(TRANSACTION_TIME_LIMIT_CONTEXT_RESOURCE_KEY);
            try {
                MessageStream<?> proceed = interceptorChain.proceed(message, context);
                task.ensureNoInterruptionWasSwallowed();
                return proceed;
            }
            catch (Exception e) {
                return MessageStream.failed(task.detectInterruptionInsteadOfException(e));
            }
        };
    }

    void initializeTimeoutIfNotInitialized(ProcessingContext context) {
        String taskName = "UnitOfWork of " + this.componentName;
        if (!context.containsResource(TRANSACTION_TIME_LIMIT_CONTEXT_RESOURCE_KEY)) {
            AxonTimeLimitedTask taskTimeout = new AxonTimeLimitedTask(taskName, this.timeout, this.warningThreshold, this.warningInterval, this.executorService, this.logger);
            context.putResource(TRANSACTION_TIME_LIMIT_CONTEXT_RESOURCE_KEY, taskTimeout);
            taskTimeout.start();
            context.runOnAfterCommit(u -> taskTimeout.complete());
            context.onError((ctx, phase, error) -> taskTimeout.complete());
        }
    }
}

